#!/usr/bin/perl

use Socket;
use strict;

$| = 1;


our ($pid, $pidage, $reply);
use vars qw($MD5available $IOSOCKETavailable $ALARMavailable $STATavailable);

BEGIN {
  $MD5available      = 0;
  $IOSOCKETavailable = 0;
  $ALARMavailable    = 0;
  $STATavailable     = 0;
}

BEGIN {
   eval '
      use Digest::MD5;
   ';
   $MD5available = 1 if !($@) ;
}

BEGIN {
   eval '
      use IO::Socket::INET;
   ';
   $IOSOCKETavailable = 1 if !($@) ;
}

BEGIN {
   eval '
      use Config;
      $ALARMavailable = 1 if $Config{d_alarm} =~ /define/;
      $STATavailable  = 1 if $Config{d_lstat} =~ /define/;
   ';
}

our $Progname = $0;
    $Progname = $' if $Progname =~ /(.+\/)/;
    $Progname = "DynAccessPoster.pl" if !$Progname;

our ($Build, $Session);

our $PSavailable = 0;
our $ps = `which ps 2>&1`; chomp($ps);
    $ps = "/bin/ps"      if $ps eq "" && -f "/bin/ps";
    $ps = "/usr/bin/ps"  if $ps eq "" && -f "/usr/bin/ps";
    $ps = "/sbin/ps"     if $ps eq "" && -f "/sbin/ps";
    $ps = "/usr/sbin/ps" if $ps eq "" && -f "/usr/sbin/ps";
    $ps = "ps"           if $ps eq "";
    $reply = `$ps -ef | grep $$ | grep $Progname | grep -v grep 2>&1`;
    $PSavailable = 1 if $reply =~ /$Progname/;

our %DirectParameters = ();
our $Debug      = 0;
our $Offline    = 0;
our $Force      = 0;
our $infoTTY    = 1;
our $infoTTY2   = 1;
our $infoBEEP   = 1;
our $infoLOG    = 1;
our $infoMESS   = 1;
our $noCONFfile = 0;
our $OnlineHelp = 0;
our $wrongparam = 0;

foreach ( @ARGV ) {
   if ( /^\-\-([a-zA-Z0-9]+)\=/ ) {  $DirectParameters{uc $1} = $';
   } elsif ( /^Force$/i ) {          $Force   = 1;
   } elsif ( /^Debug$/i ) {          $Debug   = 1;
   } elsif ( /^Offline$/i ) {        $Offline = 1;
   } elsif ( /^noMD5$/i ) {          $MD5available   = 0;
   } elsif ( /^noALARM$/i ) {        $ALARMavailable = 0;
   } elsif ( /^noSTAT$/i ) {         $STATavailable  = 0;
   } elsif ( /^noPS$/i ) {           $PSavailable    = 0;
   } elsif ( /^noTTY$/i ) {          $infoTTY    = 0; $infoTTY2 = 0;
   } elsif ( /^noTTY2$/i ) {         $infoTTY2   = 0;
   } elsif ( /^noBEEP$/i ) {         $infoBEEP   = 0;
   } elsif ( /^noLOGfile$/i ) {      $infoLOG    = 0;
   } elsif ( /^noMESSfile$/i ) {     $infoMESS   = 0;
   } elsif ( /^noCONFfile$/i ) {     $noCONFfile = 1;
   } elsif ( /^\-h/i ) {             $OnlineHelp = 1;
   } elsif ( /^\-v/i ) {             $OnlineHelp = 1;
   } else {                          $wrongparam = 1;
   }
}

our $ConfFile = '/etc/DynAccessPoster.conf';
    $ConfFile = $DirectParameters{'CONFFILE'} if $DirectParameters{'CONFFILE'};
our %INI;

&loadINI();

foreach ( @ARGV ) {
        if (/^\-h$/i)               {&OnlineHelp("-h");
   } elsif (/^\-h\-all$/i)          {&OnlineHelp("-h-all");
   } elsif (/^\-h\-start$/i)        {&OnlineHelp("-h-start");
   } elsif (/^\-h\-configfile$/i)   {&OnlineHelp("-h-configfile");
   } elsif (/^\-h\-configdirect$/i) {&OnlineHelp("-h-configdirect");
   } elsif (/^\-h\-files$/i)        {&OnlineHelp("-h-files");
   } elsif (/^\-h\-advanced$/i)     {&OnlineHelp("-h-advanced");
   } elsif (/^\-h\-md5$/i)          {&OnlineHelp("-h-md5");
   } elsif (/^\-h\-error$/i)        {&OnlineHelp("-h-error");
   } elsif (/^\-h\-cron$/i)         {&OnlineHelp("-h-cron");
   } elsif (/^\-v$/i)               {&OnlineHelp("version");
   }
}
   
&OnlineHelp("-h") if $wrongparam == 1;
#&logging("Sorry, Sie haben einen nicht gltigen Parameter verwendet!", 1, 1, 1) if $INI{'LANGUAGE'} =~ /d/i && $wrongparam == 1;
#&logging("Sorry, you used an invalid parameter!",                      1, 1, 1) if $INI{'LANGUAGE'} !~ /d/i && $wrongparam == 1;



   if (($Debug == 0) && ($Offline == 0) && ($Force == 0)) {
      if (open(FILE, "<$INI{'PIDFILE'}")) {
         ($pid, $pidage) = split(/\s/, <FILE>, 2);
         $pid    = 0 if $pidage !~ /^\d+$/;
         $pidage = 0 if $pidage !~ /^\d+$/;
         close(FILE);
      } else {$pid = 0;}
      if (($pid > 0) && ($PSavailable == 1))  {
         $reply = `$ps -ef | grep $pid | grep -v grep`;
         exit if $reply =~ /$Progname/i;
      } elsif ($pid > 0) {
         exit if time() - $pidage < 900;
      }
   }

   if ($Debug == 0) {
      defined($pid = fork) or die "Can't fork: $!";
      exit if $pid;
   }

   if (open(FILE, ">$INI{'PIDFILE'}")) {
      print FILE "$$ ". time();
      print FILE $$;
      close(FILE);
   } else {
      &logging("Sorry, kann Pid-File nicht in $INI{'PIDFILE'} speichern!", 1, 1) && $INI{'LANGUAGE'} =~ /d/i;
      &logging("Sorry, couldn't save pid-file in $INI{'PIDFILE'}!"       , 1, 1) && $INI{'LANGUAGE'} !~ /d/i;
   }
   ############### Start logging
   &logging("-", -1); &logging("-", -1); &logging("-", -1); &logging("-", -1); &logging("-", -1);
   &logging("-", -1);
   &logging("client : DynAccessPoster gestartet! (MD5-Verschlsselung ist aktiviert)"   , -1) if $MD5available == 1 && $INI{'LANGUAGE'} =~ /d/i;
   &logging("client : DynAccessPoster started! (MD5-encryption is active)"              , -1) if $MD5available == 1 && $INI{'LANGUAGE'} !~ /d/i;
   &logging("client : DynAccessPoster gestartet! (ohne zustzliche MD5-Verschlsselung)", -1) if $MD5available == 0 && $INI{'LANGUAGE'} =~ /d/i;
   &logging("client : DynAccessPoster started! (without additional MD5-encryption)"     , -1) if $MD5available == 0 && $INI{'LANGUAGE'} !~ /d/i;
   &logging("client : Debug Modus aktiviert"                                            , -1) if $Debug        == 1 && $INI{'LANGUAGE'} =~ /d/i;
   &logging("client : debug mode activated"                                             , -1) if $Debug        == 1 && $INI{'LANGUAGE'} !~ /d/i;
   &logging("client : Wegen $^O kann eine genderte Konfiguration zur Laufzeit nicht identifiziert werden", -1) if $STATavailable == 0 && $INI{'LANGUAGE'} =~ /d/i;
   &logging("client : cause of $^O it is not possible to identify a changed configuration file at runtime", -1) if $STATavailable == 0 && $INI{'LANGUAGE'} !~ /d/i;
   &logging("client : Der Poster ist in dieser Umgebung nur bedingt lauffhig!", -1)                        if $IOSOCKETavailable == 0 && $ALARMavailable == 0 && $INI{'LANGUAGE'} =~ /d/i;
   &logging("client : Greifen Sie bitte auf unsere Windows-Account-Aktualisierungssoftware zurck.", -1)    if $IOSOCKETavailable == 0 && $ALARMavailable == 0 && $INI{'LANGUAGE'} =~ /d/i;
   &logging("client : The poster wont work properly under this operation system!", -1)   if $IOSOCKETavailable == 0 && $ALARMavailable == 0 && $INI{'LANGUAGE'} !~ /d/i;
   &logging("client : Please use our windows based poster software instead.", -1)        if $IOSOCKETavailable == 0 && $ALARMavailable == 0 && $INI{'LANGUAGE'} !~ /d/i;
   &logging("Account: $INI{'ACCOUNT'}.$INI{'DOMAIN'}", -1);
   &logging("-", -1);

   sleep(15) if $Offline == 1;   



my (%IP, %IPlast, %IPlast2, %Timer, %LastTry, %Success);
$IP{'setIP'}       = "0.0.0.0";
$IP{'setIP2'}      = "0.0.0.0";
$IP{'myIP'}        = "0.0.0.0";
$IP{'HB'}          = "0.0.0.0";
$IP{'ownIP'}       = "0.0.0.0";
$IPlast{'setIP'}   = "0.0.0.0";
$IPlast{'setIP2'}  = "0.0.0.0";
$IPlast2{'setIP'}  = "0.0.0.0";
$IPlast2{'setIP2'} = "0.0.0.0";
$IPlast{'myIP'}    = "0.0.0.0";
$IPlast2{'myIP'}   = "0.0.0.0";
$IPlast{'HB'}      = "0.0.0.0";
$Success{'setIP'}  = 1;

my $HBcode     = "";
my %ErrorCounter = ();
   $ErrorCounter{'setIP'} = 0;
   $ErrorCounter{'myIP'}  = 0;
   $ErrorCounter{'Login'} = 0;
my $DNSdiff = 0;
my $ActualIP   = "0.0.0.0";


$LastTry{'setIP'}   = 0;      $Timer{'setIP'}   = 3600;
$LastTry{'checkIP'} = time(); $Timer{'checkIP'} = time();
$LastTry{'myIP'}    = time(); $Timer{'myIP'}    = time();
$LastTry{'HB'}      = time(); $Timer{'HB'}      = time();
$LastTry{'resolve'} = time(); $Timer{'resolve'} = time();
$LastTry{'beep'}    = time(); $Timer{'beep'}    = time();

my $DNSproblem  = 0;
my %noDNSmyIP   = ();
my %noDNSsetIP  = ();
my %noDNSsetIP2 = ();
my %noDNSsetIP3 = ();
my %LastSuccess = ();
   $LastSuccess{'myIP'}  = 0;
   $LastSuccess{'setIP'} = 0;

my $ConfLastModified = time();

&loadIPs();
&main();



sub main {
   my $i;
   for (;;) {

      if (open(FILE, "<$INI{'PIDFILE'}")) {
         ($pid, $pidage) = split(/\s/, <FILE>, 2);
         close(FILE);
         exit if $$ != $pid;
      } else {
         &logging("Sorry, kann Pid-File aus $INI{'PIDFILE'} nicht lesen!", 1, 1) if ($^O !~ /NetWare/i) && $INI{'LANGUAGE'} =~ /d/i;
         &logging("Sorry, could not read pid-file $INI{'PIDFILE'}!"      , 1, 1) if ($^O !~ /NetWare/i) && $INI{'LANGUAGE'} !~ /d/i;
         &logging("Terminating! Ein weiterer Poster wurde gestartet"     , 1, 1) if ($^O =~ /NetWare/i) && $INI{'LANGUAGE'} =~ /d/i;
         &logging("Terminating! Another process was started"             , 1, 1) if ($^O =~ /NetWare/i) && $INI{'LANGUAGE'} !~ /d/i;
         exit;
      }

      if (open(FILE, "> $INI{'PIDFILE'}")) {
         print FILE "$$ ". time();
         close(FILE);
      } else {
         &logging("Sorry, kann Pid-File in $INI{'PIDFILE'} nicht speichern!", 1, 1) && $INI{'LANGUAGE'} =~ /d/i;
         &logging("Sorry, could not save pid-file in $INI{'PIDFILE'}!"      , 1, 1) && $INI{'LANGUAGE'} !~ /d/i;
      }


      if (($STATavailable == 1) && (-f $ConfFile)) {
         $LastTry{'setIP'} = 0 if $ConfLastModified != (stat($ConfFile))[9];
         $ConfLastModified = (stat($ConfFile))[9] if $LastTry{'setIP'} == 0;
      }

      for ($i=0; $i<=5; $i++) {
         if ((time()-$LastTry{'HB'}      >= $Timer{'HB'})     && ($Timer{'HB'}      > 0)) {             &doHeartBeat();}
         if ((time()-$LastTry{'setIP'}   >= $Timer{'setIP'})  && ($Timer{'setIP'}   > 0)) {&loadINI();  &doSetIP();}
         if ((time()-$LastTry{'myIP'}    >= $Timer{'myIP'})   && ($Timer{'myIP'}    > 0)) {&loadINI();  &doMyIP();}
         if ((time()-$LastTry{'checkIP'} >= $Timer{'checkIP'})&& ($Timer{'checkIP'} > 0)) {&loadINI();  &checkIP();}
         if ((time()-$LastTry{'resolve'} >= $Timer{'resolve'})&& ($Timer{'resolve'} > 0)) {             &doResolve();}
         if ((time()-$LastTry{'beep'}    >= $Timer{'beep'})   && ($Timer{'beep'}    > 0)) {             &beep();}
         sleep(1);
      }
   }
}




sub doSetIP {

   my $SocketNo = " ";
   my $response = '';
   my $MESS     = '';
   my $connect  = '-';

   $LastTry{'setIP'}   = time();
   $LastTry{'myIP'}    = time(); $Timer{'myIP'}    = time();
   $LastTry{'HB'}      = time(); $Timer{'HB'}      = time();
   $LastTry{'checkIP'} = time(); $Timer{'checkIP'} = time();
   $LastTry{'resolve'} = time(); $Timer{'resolve'} = time();

   eval {
      local $SIG{'ALRM'} = sub {die "ALARM"};
      alarm(5) if $ALARMavailable == 1;
      ########################################
      #      T E S T I N G    O N L Y        #

      #  $IP{'setIP'} = "1.1.1.1";  ## uncomment for testing

      #      T E S T I N G    O N L Y        #
      ########################################


      $IP{'setIP3'} = "0.0.0.0";
      if (($IP{'setIP'} eq "0.0.0.0") && ($ErrorCounter{'setIP'} >= 15) && ($ErrorCounter{'setIP'} % 3 == 0)) {
         &resolveIP("setIP3"); $IP{'setIP'} = $IP{'setIP3'} if $IP{'setIP3'} ne "0.0.0.0";
         $SocketNo = 3                                      if $IP{'setIP3'} ne "0.0.0.0";
      }
      $IP{'setIP2'} = "0.0.0.0";
      if (($IP{'setIP'} eq "0.0.0.0") && ($ErrorCounter{'setIP'} >=  5) && ($ErrorCounter{'setIP'} % 2 == 0)) {
         &resolveIP("setIP2"); $IP{'setIP'} = $IP{'setIP2'} if $IP{'setIP2'} ne "0.0.0.0";
         $SocketNo = 2                                      if $IP{'setIP2'} ne "0.0.0.0";
      }
      &resolveIP("setIP") if $IP{'setIP'} eq "0.0.0.0";


      if ($IP{'setIP'} ne "0.0.0.0") {
         $response = "";
         if ($IOSOCKETavailable == 1) {
            $connect = IO::Socket::INET->new(PeerAddr => $IP{'setIP'},
                                             PeerPort => 905,
                                             Proto    => 'tcp',
                                             Type     => SOCK_STREAM,
                                             Timeout  => 6);
            if (defined $connect) {
               if (($Success{'setIP'} == 1) && ($MD5available == 1)) {
                  print $connect "AuthCode=MD5\012";
                  $response = <$connect>;
                  if (!($response)) {$response = "";}
                  chomp($response);
               } else {
                  $response = "";
               }
               print $connect &SendString($response);
               $response = <$connect>;
               if (!($response)) {$response = "";}
               chomp($response);
            }
            close($connect);
         } else {
            socket( S, PF_INET, SOCK_STREAM, getprotobyname('tcp'));

            my $Saddr = gethostbyname($IP{'setIP'});
            $connect = connect(S, sockaddr_in('905', $Saddr));
            select S; $| = 1; select STDOUT; $| = 1;

            if ($connect) {
               if (($Success{'setIP'} == 1) && ($MD5available == 1)) {
                  print S "AuthCode=MD5\012";
                  $response = <S>;
                  if (!($response)) {$response = "";}
                  chomp($response);
               } else {
                  $response = "";
               }
               print S &SendString($response);
               $response = <S>;
               if (!($response)) {$response = "";}
               chomp($response);
            }
            close S;
         }
      } else {
         $LastTry{'setIP'} = time() - $Timer{'setIP'} + 1;
      }
   };

   alarm(0) if $ALARMavailable == 1;
   if (($@ && $@ =~ /ALARM/) || (not defined $connect)) {
      close S         if $IOSOCKETavailable == 0;
      close($connect) if $IOSOCKETavailable == 1 && defined $connect && $connect =~ /IO/;
      &logging("setIP$SocketNo : Kann Account-Aktualisierung nicht durchfhren (abgebrochen) [$IP{'setIP'}]")   if $INI{'LANGUAGE'} =~ /d/i;
      &logging("setIP$SocketNo : There is a problem to do a setIP (canceled) [$IP{'setIP'}]")                   if $INI{'LANGUAGE'} !~ /d/i;
     #&logging("ffnen Sie bitte TCP-Port 905 (ausgehend) in Ihrer Firewall, wenn aktuell nicht geschehen", 1, 0, 1) if $INI{'LANGUAGE'} =~ /d/i && time() - $LastSuccess{'setIP'} > 1800 && $ErrorCounter{'setIP'} > 15;
     #&logging("Please open TCP-Port 905 (outgoing access) in your firewall if actually not", 1, 0, 1)               if $INI{'LANGUAGE'} !~ /d/i && time() - $LastSuccess{'setIP'} > 1800 && $ErrorCounter{'setIP'} > 15;

      $IPlast2{'setIP'}  = $IPlast{'setIP'};
      $IPlast2{'setIP2'} = $IPlast{'setIP'};
      $IPlast{'setIP'}   = $IP{'setIP'};
      $IPlast{'setIP2'}  = $IP{'setIP'};
      $IP{'setIP'}       = "0.0.0.0";
      $IP{'setIP2'}      = "0.0.0.0";
      $LastTry{'setIP'}  = time() - $Timer{'setIP'} +   5;
      $LastTry{'setIP'}  = time() - $Timer{'setIP'} +  15 if $ErrorCounter{'setIP'} >  5;
      $LastTry{'setIP'}  = time() - $Timer{'setIP'} +  30 if $ErrorCounter{'setIP'} > 10;
      $LastTry{'setIP'}  = time() - $Timer{'setIP'} + 120 if $ErrorCounter{'setIP'} > 15;
      $Success{'setIP'}  = 0;
      $ErrorCounter{'setIP'}++;
      &main();
   } else {
      if ($response =~ /IP:\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}/) {
         if ($response =~ /^IP:(.*?)\s/)         {$ActualIP = $1;}          else {$ActualIP = "";} $ActualIP = &isIP($ActualIP);
         if ($response =~ /\sSI:(\d{1,5})\s/)    {$Timer{'setIP'} = $1;}    else {$Timer{'setIP'}    = 1800;}
         if ($response =~ /\sMI:(\d{1,5})\s/)    {$Timer{'myIP'}  = $1;}    else {$Timer{'myIP'}     = 120;}
                                                  $Timer{'myIP'}  = 60      if $Timer{'myIP'}       <= 5;
         if ($response =~ /\sCI:(\d{1,5})\s/)    {$Timer{'checkIP'}  = $1;} else {$Timer{'checkIP'}  = time();}
         if ($response =~ /\sRI:(\d{1,3})\s/)    {$Timer{'resolve'}  = $1;} else {$Timer{'resolve'}  = time();}
         if ($response =~ /\sHB:([A-Z]{20})\s/)  {$HBcode         = $1;}    else {$HBcode            = "";}
         if ($response =~ /\sHI:(\d{1,2})\s/)    {$Timer{'HB'}    = $1;}    else {$HBcode            = "";}
         if ($response =~ /\sDNS:1\s/)           {$IP{'setIP'} = "0.0.0.0"; $IP{'myIP'} = "0.0.0.0";  $IP{'HB'} = "0.0.0.0";}
         if ($response =~ /\sSIP:(.{7,15)\s/)    {$IP{'myIP'}  = &isIP($1);}
         if ($response =~ /\sMIP:(.{7,15})\s/)   {$IP{'HB'}    = &isIP($1);}
         if ($response =~ /\sMESS:(.*)/)         {$MESS = $1;} else {$MESS = '';}

         $response = $1 if $response =~ /(.+)MESS\:/ && $MESS ne '';
         &logging("setIP$SocketNo : $response [$IP{'setIP'}]")                                        if        defined $INI{'LOGSETIP'};
         &logging("setIP$SocketNo : Account-Aktualisierung erfolgreich durchgefhrt! [$IP{'setIP'}]") if  (($response !~ /C1:/) && (not defined $INI{'LOGSETIP'}) && ($INI{'LANGUAGE'} =~ /d/i));
         &logging("setIP$SocketNo : SetIP done successfully! [$IP{'setIP'}]")                         if  (($response !~ /C1:/) && (not defined $INI{'LOGSETIP'}) && ($INI{'LANGUAGE'} !~ /d/i));
         &logging("setIP$SocketNo : Account-Aktualisierung wurde zurckgewiesen! [$IP{'setIP'}]")     if  (($response =~ /C1:/) && (not defined $INI{'LOGSETIP'}) && ($INI{'LANGUAGE'} =~ /d/i));
         &logging("setIP$SocketNo : SetIP rejected! [$IP{'setIP'}]")                                  if  (($response =~ /C1:/) && (not defined $INI{'LOGSETIP'}) && ($INI{'LANGUAGE'} !~ /d/i));
         &logging($MESS, 1, 0, 1)                                                             if  length($MESS) > 0;
         $Timer{'beep'} = time(); $LastTry{'beep'} = time() - 61; $Timer{'beep'} = 60         if  length($MESS) > 0;
         if ($response =~ /\sSLEEP:(\d{1,4})\s/) {sleep($1) if $1 > 0;}
         if ($response =~ /\sEXIT:1\s/)          {sleep(3600); unlink($INI{'PIDFILE'}); exit;}

         $LastSuccess{'setIP'}     = time;
         $Success{'setIP'}         = 1;
         $ErrorCounter{'setIP'}    = 0;
         $ErrorCounter{'Login'}    = 0;
         $IP{'HB'}    = "0.0.0.0";
         $IP{'myIP'}  = "0.0.0.0";
         $IP{'setIP'} = "0.0.0.0";

         if ($Offline == 1) {
            &logging("Mode   : Offline-Schaltung aktiviert!") if $INI{'LANGUAGE'} =~ /d/i;
            &logging("Mode   : offline-mode activated!")      if $INI{'LANGUAGE'} !~ /d/i;
            unlink($INI{'PIDFILE'});
            exit; 
         }

         if ($response =~ /C1:3/) {
            $ErrorCounter{'Login'}++;
            sleep($ErrorCounter{'Login'}*60);
            if ($ErrorCounter{'Login'} > 10) {
               &logging("Mode   : Terminating in 1 hour!!!!");
               sleep(3600);
               unlink($INI{'PIDFILE'}); exit;
            }
         }
      } else {
         &logging("setIP$SocketNo : Kann Account-Aktualisierung nicht durchfhren [$IP{'setIP'}]") if $INI{'LANGUAGE'} =~ /d/i;
         &logging("setIP$SocketNo : There is a problem to do a setIP [$IP{'setIP'}]")              if $INI{'LANGUAGE'} !~ /d/i;
         &logging("Dieser Poster ist zur Account-Aktualisieurng nicht authorisiert.", 1, 1, 1) if $INI{'LANGUAGE'} =~ /d/i && $response =~ /unknown authcode/;
         &logging("This poster is not authorized.",                                   1, 1, 1) if $INI{'LANGUAGE'} !~ /d/i && $response =~ /unknown authcode/;
         &logging("ffnen Sie bitte TCP-Port 905 (ausgehend) in Ihrer Firewall, wenn aktuell nicht geschehen", 1, 0, 1) if $INI{'LANGUAGE'} =~ /d/i && time() - $LastSuccess{'setIP'} > 1800 && $ErrorCounter{'setIP'} > 15;
         &logging("Please open TCP-Port 905 (outgoing access) in your firewall if actually not", 1, 0, 1)               if $INI{'LANGUAGE'} !~ /d/i && time() - $LastSuccess{'setIP'} > 1800 && $ErrorCounter{'setIP'} > 15;
         $IPlast2{'setIP'}  = $IPlast{'setIP'};
         $IPlast2{'setIP2'} = $IPlast{'setIP'};
         $IPlast{'setIP'}   = $IP{'setIP'};
         $IPlast{'setIP2'}  = $IP{'setIP'};
         $IP{'setIP'}       = "0.0.0.0";
         $IP{'setIP2'}      = "0.0.0.0";
         $LastTry{'setIP'}  = time() - $Timer{'setIP'} +   5;
         $LastTry{'setIP'}  = time() - $Timer{'setIP'} +  15 if $ErrorCounter{'setIP'} >  5;
         $LastTry{'setIP'}  = time() - $Timer{'setIP'} +  30 if $ErrorCounter{'setIP'} > 10;
         $LastTry{'setIP'}  = time() - $Timer{'setIP'} + 120 if $ErrorCounter{'setIP'} > 15;
         $LastTry{'setIP'}  = time() - $Timer{'setIP'} + 300 if $ErrorCounter{'setIP'} > 25;
         $Success{'setIP'}  = 0;
         $ErrorCounter{'setIP'}++;
      }
   }
}



sub doMyIP {

   my $response = '';
   my $connect  = '-';

   my $myIP;

   &resolveIP("myIP"); 


   $LastTry{'myIP'} = time();
   eval {
      local $SIG{'ALRM'} = sub {die "ALARM"};
      alarm(5) if $ALARMavailable == 1;
      my ($Saddr);

      if ($IP{'myIP'} ne "0.0.0.0") {
         $myIP = "0.0.0.0";
         if ($IOSOCKETavailable == 1) {
            $connect = IO::Socket::INET->new(PeerAddr => $IP{'myIP'},
                                             PeerPort => 906,
                                             Proto    => 'tcp',
                                             Type     => SOCK_STREAM,
                                             Timeout  => 6);
            if ($connect) {
               print $connect "AuthCode=$INI{'AUTHCODE'}\012";
               $myIP = &isIP(<$connect>);
            }
            close($connect);
         } else {
            socket( S, PF_INET, SOCK_STREAM, getprotobyname('tcp'));

            $Saddr = gethostbyname($IP{'myIP'});
            $connect = connect(S, sockaddr_in('906', $Saddr));
            select S; $| = 1; select STDOUT; $| = 1;

            if ($connect) {
               print S "AuthCode=$INI{'AUTHCODE'}\012";
               $myIP = &isIP(<S>);
            }
            close S;
         }

      } else {
         $LastTry{'myIP'}  = time() - $Timer{'myIP'} + 15 if $LastTry{'setIP'} + $Timer{'setIP'} - time() < 30;
      }
   };

   alarm(0) if $ALARMavailable == 1;
   if (($@ && $@ =~ /ALARM/) || (not defined $connect)) {
      close S         if $IOSOCKETavailable == 0;
      close($connect) if $IOSOCKETavailable == 1 && defined $connect && $connect =~ /IO/;
      &logging("myIP   : Konnte eigene IP nicht ermitteln (abgebrochen) [$IP{'myIP'}]")                              if $INI{'LANGUAGE'} =~ /d/i;
      &logging("myIP   : There is a problem to do a myIP (canceled) [$IP{'myIP'}]")                                  if $INI{'LANGUAGE'} !~ /d/i;
      &logging("ffnen Sie bitte TCP-Port 906 (ausgehend) in Ihrer Firewall, wenn aktuell nicht geschehen", 1, 0, 1) if $INI{'LANGUAGE'} =~ /d/i && time() - $LastSuccess{'myIP'} > 1800 && $ErrorCounter{'myIP'} > 5;
      &logging("Please open TCP-Port 906 (outgoing access) in your firewall if actually not", 1, 0, 1)               if $INI{'LANGUAGE'} !~ /d/i && time() - $LastSuccess{'myIP'} > 1800 && $ErrorCounter{'myIP'} > 5;

      $IPlast2{'myIP'} = $IPlast{'myIP'}; 
      $IPlast{'myIP'}  = $IP{'myIP'};
      $IP{'myIP'}      = "0.0.0.0";
      $LastTry{'myIP'} = time() - $Timer{'myIP'} + 30;
      $ErrorCounter{'myIP'}++;
      &main();
   } else {
      if ($myIP ne "0.0.0.0") {
         if ($myIP ne $ActualIP) {
            $LastTry{'HB'}      = 0;
            $LastTry{'setIP'}   = time()-$Timer{'setIP'}+5;
            $LastTry{'checkIP'} = time();
            $LastTry{'resolve'} = time();
            $ActualIP = $myIP;
            &logging("myIP   : IP-Wechsel festgestellt $myIP  [$IP{'myIP'}]")  if $INI{'LANGUAGE'} =~ /d/i;
            &logging("myIP   : IP-Change detected $myIP  [$IP{'myIP'}]")       if $INI{'LANGUAGE'} !~ /d/i;
         } else {
            &logging("myIP   : $ActualIP  [$IP{'myIP'}]") if defined $INI{'LOGMYIP'};
         }
         $ErrorCounter{'myIP'} = 0;
         $LastSuccess{'myIP'}  = time;
      } else {
         &logging("myIP   : Konnte eigene IP nicht ermitteln [$IP{'myIP'}]")                                            if $INI{'LANGUAGE'} =~ /d/i;
         &logging("myIP   : There is a problem to do a myIP [$IP{'myIP'}]")                                             if $INI{'LANGUAGE'} !~ /d/i;
         &logging("ffnen Sie bitte TCP-Port 906 (ausgehend) in Ihrer Firewall, wenn aktuell nicht geschehen", 1, 0, 1) if $INI{'LANGUAGE'} =~ /d/i && time() - $LastSuccess{'myIP'} > 1800 && $ErrorCounter{'myIP'} > 5;
         &logging("Please open TCP-Port 906 (outgoing access) in your firewall if actually not", 1, 0, 1)               if $INI{'LANGUAGE'} !~ /d/i && time() - $LastSuccess{'myIP'} > 1800 && $ErrorCounter{'myIP'} > 5;
         $IPlast2{'myIP'} = $IPlast{'myIP'}; 
         $IPlast{'myIP'}  = $IP{'myIP'};
         $IP{'myIP'}      = "0.0.0.0";
         $LastTry{'myIP'} = time() - $Timer{'myIP'} + 30;
         $ErrorCounter{'myIP'}++;
      }
   }
}



sub doHeartBeat {

   &resolveIP("HB");

   $LastTry{'HB'} = time();
   if ((length($HBcode) == 20) && ($IP{'HB'} ne "0.0.0.0") && (defined $INI{'USEHEARTBEAT'})) {
      my ($Saddr, $connect, $response);

      socket( S, PF_INET, SOCK_DGRAM, getprotobyname('udp'));
      $Saddr = gethostbyname($IP{'HB'});
      $connect = send(S, $HBcode, 0, sockaddr_in('910', $Saddr));
      close S;
      &logging("HB     : Sende einen HeartBeat [$IP{'HB'}]") if defined $INI{'LOGHEARTBEAT'} && $INI{'LANGUAGE'} =~ /d/i;
      &logging("HB     : Sending a HeartBeat [$IP{'HB'}]")   if defined $INI{'LOGHEARTBEAT'} && $INI{'LANGUAGE'} !~ /d/i;
   }
}



sub checkIP {

   &resolveIP("ownIP");

   $LastTry{'checkIP'} = time();
   if ($IP{'ownIP'} ne "0.0.0.0") {
      if ($IP{'ownIP'} ne $ActualIP) {
         if ($DNSdiff <= 5) {
            $LastTry{'setIP'} = 0;
            &logging("checkIP: IP difference detected ----> DNS:$IP{'ownIP'} Actual:$ActualIP ") if defined $INI{'DEBUG'};
         }
         $DNSdiff++;
      } else {
         $DNSdiff = 0;
      }
      $IP{'ownIP'}     = "0.0.0.0";
   } else {
      $LastTry{'checkIP'} = time() - $Timer{'checkIP'} + 30;
   }
}



sub doResolve {
   my $dummy;

   $LastTry{'resolve'} = time();
   eval {
      local $SIG{'ALRM'} = sub {die "ALARM"};
      alarm 1 if $ALARMavailable == 1;
      $dummy = "";
      while (length($dummy) < 6) {$dummy .= chr(int(rand(25))+97);}
      $dummy = gethostbyname("$dummy.com");
      alarm(0) if $ALARMavailable == 1;
   };
   alarm(0) if $ALARMavailable == 1;
}



sub SendString {

   my $MD5code = shift;
   my $MD5;

   my ($offset, $i);
   my ($SendString, $SendString2);


   $SendString  = "AuthCode=$INI{'AUTHCODE'}";
   $SendString .= "&Account=$INI{'ACCOUNT'}";
   $SendString .= "&Domain=$INI{'DOMAIN'}";
   $SendString .= "&Expire=10M" if $IOSOCKETavailable == 1 || $ALARMavailable == 1;
   $SendString .= "&Expire=25M" if $IOSOCKETavailable == 0 && $ALARMavailable == 0;
   $SendString .= "&ec=$ErrorCounter{'setIP'}";
   $SendString .= "&ec2=$ErrorCounter{'myIP'}";
   $SendString .= "&DNSproblem=$DNSproblem";
   $SendString .= "&dnsdiff=$DNSdiff";
   $SendString .= "&build=$Build";
   $SendString .= "&session=$Session";
   $SendString .= "&os=$^O  ".sprintf ("%vd", $^V)." $ALARMavailable $STATavailable" if  $^X =~ /(perl)|(perl\.exe)$/i; 
   $SendString .= "&os=LINUX binary"                                                 if  $^X !~ /(perl)|(perl\.exe)$/i; 
   $SendString .= "&offline=1"  if $Offline == 1;
   $SendString .= "&ADVSETIP=1" if $INI{'USEHEARTBEAT'} == 0;

   ### MD5
   if ($MD5available == 1) {
      $MD5 = Digest::MD5->new;
      $MD5->add($INI{'PASSWD'});
      $MD5->add($MD5code) if length($MD5code) < 0;
      $SendString .= "&Passwd=".$MD5->hexdigest;
   } else {
      $SendString .= "&Passwd=$INI{'PASSWD'}";
   }

   ### ROT 13
   $SendString2 = $SendString;
   $SendString  = "";
   $offset = int(rand(12))+1;
   for ($i=0; $i < length($SendString2); $i++) {
      $SendString .= chr(ord(substr($SendString2, $i, 1))+$offset);
   }

   $SendString .= "\012";
   return $SendString;
}



sub loadINI {
   my ($INI, $id, $val);

   $Build = "051209";

   %INI = ();

   if ($noCONFfile == 0) {
      if (!(-f $ConfFile)) {if (open CONFIG, ">>$ConfFile") {print CONFIG ""; close CONFIG;}}
      if (open CONFIG, "<$ConfFile") {
         $INI = "";
         $INI .= $_ while <CONFIG>;
         close CONFIG;

         if ($INI !~ /^Account/ism)      {if (open CONFIG, ">>$ConfFile") {print CONFIG "Account      =\n";                close CONFIG;}}
         if ($INI !~ /^Domain/ism)       {if (open CONFIG, ">>$ConfFile") {print CONFIG "Domain       = dynaccess.de\n";   close CONFIG;}}
         if ($INI !~ /^Passwd/ism)       {if (open CONFIG, ">>$ConfFile") {print CONFIG "Passwd       =\n";                close CONFIG;}}
         if ($INI !~ /^Language/ism)     {if (open CONFIG, ">>$ConfFile") {print CONFIG "Language     = en\n";             close CONFIG;}}
         if ($INI !~ /^UseHeartBeat/ism) {if (open CONFIG, ">>$ConfFile") {print CONFIG "UseHeartBeat = 1\n";              close CONFIG;}}
         if ($INI !~ /^LogHeartBeat/ism) {if (open CONFIG, ">>$ConfFile") {print CONFIG "LogHeartBeat = 0\n";              close CONFIG;}}
         if ($INI !~ /^LogSetIP/ism)     {if (open CONFIG, ">>$ConfFile") {print CONFIG "LogSetIP     = 0\n";              close CONFIG;}}
         if ($INI !~ /^LogMyIP/ism)      {if (open CONFIG, ">>$ConfFile") {print CONFIG "LogMyIP      = 0\n";              close CONFIG;}}
         if ($INI !~ /^LogServer/ism)    {if (open CONFIG, ">>$ConfFile") {print CONFIG "LogServer    = 1\n";              close CONFIG;}}
         if ($INI !~ /^PidFile/ism)      {if (open CONFIG, ">>$ConfFile") {print CONFIG "PidFile      = /var/run/DynAccessPoster.pid\n";  close CONFIG;}}
         if ($INI !~ /^LogFile/ism)      {if (open CONFIG, ">>$ConfFile") {print CONFIG "LogFile      = /var/log/DynAccessPoster\n";      close CONFIG;}}
         if ($INI !~ /^MessFile/ism)     {if (open CONFIG, ">>$ConfFile") {print CONFIG "MessFile     = /var/log/DynAccessPoster.mess\n"; close CONFIG;}}

         $INI =~ s/\r\n/\n/og;
         $INI =~ s/\n\r/\n/og;
         $INI =~ s/\r/\n/og;
         $INI =~ s/[\t ]+\n/\n/og;
         while ( $INI =~ /(?:\n|^)([\w\d\[\]\-]+)[\t ]*\=[\t ]*([^\n]*)/ ) {
            $INI = $';
            $id = uc($1);
            $val = $2;
            chomp $val;
            $val = undef if $val && $val eq "";
            $id =~ s/(\s|_)//og;
            $INI{$id} = undef;
            $INI{$id} = $val if defined $val;
         }
      } else {
         &logging("Sorry, kann Config-File nicht in $ConfFile speichern!", 1, 1, 1) if $INI{'LANGUAGE'} =~ /d/i && $wrongparam == 0 && $OnlineHelp == 0;
         &logging("Sorry, could not save config-File in $ConfFile!",       1, 1, 1) if $INI{'LANGUAGE'} =~ /d/i && $wrongparam == 0 && $OnlineHelp == 0;
      }
   }

   if (not defined $INI{'PIDFILE'})      {$INI{'PIDFILE'}      = "/var/run/DynAccessPoster.pid";}
   if (not defined $INI{'LOGFILE'})      {$INI{'LOGFILE'}      = "/var/log/DynAccessPoster.log";}
   if (not defined $INI{'MESSFILE'})     {$INI{'MESSFILE'}     = "/var/log/DynAccessPoster.mess";}
   if (not defined $INI{'AUTHCODEFILE'}) {$INI{'AUTHCODEFILE'} = "/etc/DynAccessPoster.authcode";}

   if (defined $INI{'LANGUAGE'})     {$INI{'LANGUAGE'}     = "de"  if $INI{'LANGUAGE'}     =~ /d/i;} else {$INI{'LANGUAGE'} = "en";}
   if (defined $INI{'USEHEARTBEAT'}) {$INI{'USEHEARTBEAT'} = undef if $INI{'USEHEARTBEAT'} ne "1";}
   if (defined $INI{'LOGHEARTBEAT'}) {$INI{'LOGHEARTBEAT'} = undef if $INI{'LOGHEARTBEAT'} ne "1";}
   if (defined $INI{'LOGSETIP'})     {$INI{'LOGSETIP'}     = undef if $INI{'LOGSETIP'}     ne "1";}
   if (defined $INI{'LOGMYIP'})      {$INI{'LOGMYIP'}      = undef if $INI{'LOGMYIP'}      ne "1";}
   if (defined $INI{'LOGSERVER'})    {$INI{'LOGSERVER'}    = undef if $INI{'LOGSERVER'}    ne "1";}
   if (defined $INI{'DEBUG'})        {$INI{'DEBUG'}        = undef if $INI{'DEBUG'}        ne "1";}


   $INI{'PIDFILE'}      = $DirectParameters{'PIDFILE'}      if defined $DirectParameters{'PIDFILE'};
   $INI{'LOGFILE'}      = $DirectParameters{'LOGFILE'}      if defined $DirectParameters{'LOGFILE'};
   $INI{'MESSFILE'}     = $DirectParameters{'MESSFILE'}     if defined $DirectParameters{'MESSFILE'};
   $INI{'AUTHCODEFILE'} = $DirectParameters{'AUTHCODEFILE'} if defined $DirectParameters{'AUTHCODEFILE'};
   $INI{'LANGUAGE'}     = $DirectParameters{'LANGUAGE'}     if defined $DirectParameters{'LANGUAGE'} && $DirectParameters{'LANGUAGE'} =~ /^(de|en)$/i;
   if (-f "$INI{'AUTHCODEFILE'}") {
      if (open CONFIG, "<$INI{'AUTHCODEFILE'}") {
         $INI{'AUTHCODE'} = "";
         $INI{'AUTHCODE'} .= $_ while <CONFIG>;
         close CONFIG;
      }
   }
   if (defined $DirectParameters{'USEHEARTBEAT'}) {$INI{'USEHEARTBEAT'} = $DirectParameters{'USEHEARTBEAT'}; $INI{'USEHEARTBEAT'} = undef if $INI{'USEHEARTBEAT'} ne "1";}
   if (defined $DirectParameters{'LOGHEARTBEAT'}) {$INI{'LOGHEARTBEAT'} = $DirectParameters{'LOGHEARTBEAT'}; $INI{'LOGHEARTBEAT'} = undef if $INI{'LOGHEARTBEAT'} ne "1";}
   if (defined $DirectParameters{'LOGSETIP'})     {$INI{'LOGSETIP'}     = $DirectParameters{'LOGSETIP'};     $INI{'LOGSETIP'}     = undef if $INI{'LOGSETIP'}     ne "1";}
   if (defined $DirectParameters{'LOGMYIP'})      {$INI{'LOGMYIP'}      = $DirectParameters{'LOGMYIP'};      $INI{'LOGMYIP'}      = undef if $INI{'LOGMYIP'}      ne "1";}
   if (defined $DirectParameters{'LOGSERVER'})    {$INI{'LOGSERVER'}    = $DirectParameters{'LOGSERVER'};    $INI{'LOGSERVER'}    = undef if $INI{'LOGSERVER'}    ne "1";}
   if (defined $DirectParameters{'DEBUG'})        {$INI{'DEBUG'}        = $DirectParameters{'DEBUG'};        $INI{'DEBUG'}        = undef if $INI{'DEBUG'}        ne "1";}
   if (defined $DirectParameters{'AUTHCODE'})     {$INI{'AUTHCODE'}     = $DirectParameters{'AUTHCODE'};}

   $INI{'ACCOUNT'}  = $DirectParameters{'ACCOUNT'}  if defined $DirectParameters{'ACCOUNT'};
   $INI{'DOMAIN'}   = $DirectParameters{'DOMAIN'}   if defined $DirectParameters{'DOMAIN'};
   $INI{'PASSWD'}   = $DirectParameters{'PASSWD'}   if defined $DirectParameters{'PASSWD'};

   $INI{'AUTHCODE'} = "HBSocket2" if not defined $INI{'AUTHCODE'};
   $INI{'AUTHCODE'} =~ s/[^A-Za-z0-9\-]//g; 
   ($INI{'ACCOUNT'}, $INI{'DOMAIN'}) = split(/\./, $DirectParameters{'HOSTNAME'}, 2) if defined $DirectParameters{'HOSTNAME'} && $DirectParameters{'HOSTNAME'} =~ /.+\..+\..+/;

   if ((not defined $INI{'ACCOUNT'}) || (not defined $INI{'DOMAIN'}) || (not defined $INI{'PASSWD'})) {
      if ($noCONFfile == 0) {
         &logging("Konfigurieren Sie bitte zunchst Ihre Zugangsdaten in $ConfFile", 1, 1, 1) if $INI{'LANGUAGE'} =~ /d/i && $wrongparam == 0 && $OnlineHelp == 0;
         &logging("Please configure your account-access-data in $ConfFile first", 1, 1, 1)    if $INI{'LANGUAGE'} !~ /d/i && $wrongparam == 0 && $OnlineHelp == 0;
      } else {
         &logging("Geben Sie bitte bei der direkten Parameterbergabe Ihre Account-Daten an.", 1, 1, 1) if $INI{'LANGUAGE'} =~ /d/i && $wrongparam == 0 && $OnlineHelp == 0;
         &logging("Please configure your account-access-data.",                                1, 1, 1) if $INI{'LANGUAGE'} !~ /d/i && $wrongparam == 0 && $OnlineHelp == 0;
      }
   }
   $INI{'ACCOUNT'} = $1 if $INI{'ACCOUNT'} =~ /^(.+?)\./;

   $Session = "" if not defined $Session;
   while (length($Session) < 3) {$Session .= chr(int(rand(25))+65);}

}



sub loadIPs {

   my $LOGfilesize = 0;
   my $LOGfileline = "";
   my $IPlist = "";
   my @keys = ();

   #if (open LOGfile, "<$INI{'LOGFILE'}") {
   #   if ($STATavailable == 1) {
   #      $LOGfilesize = (stat($INI{'LOGFILE'}))[7];
   #      do {$LOGfileline = <LOGfile>;  $LOGfilesize -= length($LOGfileline);} until $LOGfilesize < 1048576;
   #   }
   #   &logging("loadIPs: Lese Socket-IPs ein, die bei DNS-Problemen verwendet werden") if $INI{'LANGUAGE'} =~ /d/i;
   #   &logging("loadIPs: Looking for socket-IPs which can be used at DNS problems")    if $INI{'LANGUAGE'} !~ /d/i;
   #
   #   while ($LOGfileline = <LOGfile>) {
   #      $noDNSsetIP{"$1.$2.$3.$4"}  = 1 if $LOGfileline =~ /.{20,30}setIP\s*\:.+?\[([1-9]\d{0,2}).(\d{1,3}).(\d{1,3}).(\d{1,3})\]\n/i;
   #      $noDNSsetIP2{"$1.$2.$3.$4"} = 1 if $LOGfileline =~ /.{20,30}setIP2\s*\:.+?\[([1-9]\d{0,2}).(\d{1,3}).(\d{1,3}).(\d{1,3})\]\n/i;
   #      $noDNSsetIP3{"$1.$2.$3.$4"} = 1 if $LOGfileline =~ /.{20,30}setIP3\s*\:.+?\[([1-9]\d{0,2}).(\d{1,3}).(\d{1,3}).(\d{1,3})\]\n/i;
   #      $noDNSmyIP{"$1.$2.$3.$4"}   = 1 if $LOGfileline =~ /.{20,30}myIP\s*\:.+?\[([1-9]\d{0,2}).(\d{1,3}).(\d{1,3}).(\d{1,3})\]\n/i;
   #   }
   #   close LOGfile;
   #}

   $noDNSsetIP{'217.114.73.110'}    = 1;
   $noDNSsetIP{'217.114.73.111'}    = 1;
   $noDNSsetIP{'217.114.73.115'}    = 1;
   $noDNSsetIP{'217.114.73.116'}    = 1;
   $noDNSsetIP{'217.114.73.120'}    = 1;
   $noDNSsetIP{'217.114.73.121'}    = 1;


   $noDNSsetIP2{'217.114.73.112'}   = 1;
   $noDNSsetIP2{'217.114.73.117'}   = 1;
   $noDNSsetIP2{'217.114.73.122'}   = 1;

   $noDNSsetIP3{'213.133.103.135'} = 1;
   $noDNSsetIP3{'217.160.184.146'} = 1;
   $noDNSsetIP3{'62.112.159.162'}  = 1;

   $noDNSmyIP{'213.133.103.135'}  = 1;
   $noDNSmyIP{'217.160.184.146'}  = 1;
   $noDNSmyIP{'62.112.159.162'}   = 1;

   @keys = keys %noDNSsetIP;  $IPlist =  join(" ", @keys);       &logging("setIP  : $IPlist") if $Debug == 1;
   @keys = keys %noDNSsetIP2; $IPlist =  join(" ", @keys);       &logging("setIP2 : $IPlist") if $Debug == 1;
   @keys = keys %noDNSsetIP3; $IPlist =  join(" ", @keys);       &logging("setIP3 : $IPlist") if $Debug == 1;
   @keys = keys %noDNSmyIP;   $IPlist =  join(" ", @keys);       &logging("myIP   : $IPlist") if $Debug == 1;

}



sub resolveIP {

   my $Socket = shift;

   if ($Socket =~ /^(setIP|setIP2|setIP3|myIP|HB|ownIP)$/) {
      eval {
         local $SIG{'ALRM'} = sub {die "ALARM"};
         alarm(5) if $ALARMavailable == 1;

         my $i=0;
         while (($IP{$Socket} eq "0.0.0.0") && ($i<=20)) {
            $IP{$Socket} = gethostbyname('socket-setip.dynaccess.de')       if $Socket eq "setIP";
            $IP{$Socket} = gethostbyname('socket-setip2.dynaccess.de')      if $Socket eq "setIP2";
            $IP{$Socket} = gethostbyname('socket-setip3.dynaccess.de')      if $Socket eq "setIP3";
            $IP{$Socket} = gethostbyname('socket-myip.dynaccess.de')        if $Socket eq "myIP";
            $IP{$Socket} = gethostbyname('heartbeat.dynaccess.de')          if $Socket eq "HB";
            $IP{$Socket} = gethostbyname("$INI{'ACCOUNT'}.$INI{'DOMAIN'}")  if $Socket eq "ownIP";
            if ($IP{$Socket}) {
               $IP{$Socket} =join(".", unpack('C4',$IP{$Socket}));
               if ($IP{$Socket}) {
                  $IP{$Socket} = &isIP($IP{$Socket});
               } else {
                  $IP{$Socket} = "0.0.0.0";
               }
            } else {
               $IP{$Socket} = "0.0.0.0";
            }
            $IP{$Socket} = "0.0.0.0" if defined $IPlast{$Socket}  && $IP{$Socket} eq $IPlast{$Socket};
            $IP{$Socket} = "0.0.0.0" if defined $IPlast2{$Socket} && $IP{$Socket} eq $IPlast2{$Socket} && $Socket =~ /^[setIP|myIP]$/;
            $IP{$Socket} = "0.0.0.0" if defined $IPlast2{$Socket} && $IP{$Socket} eq $IPlast2{$Socket} && $Socket =~ /^[setIP]$/;
            $i++;
         }
         $IP{$Socket} = $IPlast{$Socket} if $IPlast{$Socket} && $IP{$Socket} eq "0.0.0.0";
      };
      alarm(0) if $ALARMavailable == 1;
      if ($@ && $@ =~ /ALARM/) {
         $IP{$Socket} = "0.0.0.0";
      }
   } else {
      $IP{$Socket} = "0.0.0.0";
   }
   #$IP{$Socket} = "0.0.0.0";               ################# testing
   if ($IP{$Socket} eq "0.0.0.0") {
      $DNSproblem++;
      if ($Socket =~ /^(setIP|setIP2|setIP3|myIP)$/) {
         my @keys = ();
         @keys = keys %noDNSsetIP  if $Socket eq "setIP";
         @keys = keys %noDNSsetIP2 if $Socket eq "setIP2";
         @keys = keys %noDNSsetIP3 if $Socket eq "setIP3";
         @keys = keys %noDNSmyIP   if $Socket eq "myIP";
         &loadIPs()                if $#keys <= 0;
         $IP{$Socket} = pop(@keys) if $#keys >= 0;
         delete $noDNSsetIP{$IP{$Socket}}  if $Socket eq "setIP";
         delete $noDNSsetIP2{$IP{$Socket}} if $Socket eq "setIP2";
         delete $noDNSsetIP3{$IP{$Socket}} if $Socket eq "setIP3";
         delete $noDNSmyIP{$IP{$Socket}}   if $Socket eq "myIP";
         &logging("DNS    : Es besteht ein lokales DNS-Problem! ($Socket) Versuche gespeicherte IP $IP{$Socket} zu verwenden") if $IP{$Socket} ne "0.0.0.0" && $INI{'LANGUAGE'} =~ /d/i;
         &logging("DNS    : There is a DNS-resolving problem! ($Socket) Trying to use guessed IP $IP{$Socket}")                if $IP{$Socket} ne "0.0.0.0" && $INI{'LANGUAGE'} !~ /d/i;
      }
   } else {
      $DNSproblem = 0;
   }
   &logging("DNS    : Es besteht ein lokales DNS-Problem! ($Socket)") if $IP{$Socket} eq "0.0.0.0" && $INI{'LANGUAGE'} =~ /d/i;
   &logging("DNS    : There is a DNS-resolving problem! ($Socket)")   if $IP{$Socket} eq "0.0.0.0" && $INI{'LANGUAGE'} !~ /d/i;
}



sub isIP {
   my $CheckIP = shift;
   if (!($CheckIP)) {$CheckIP = "";}
   chomp($CheckIP);

   my @Split = ();
   my $Result = $CheckIP;

   if ($CheckIP =~ /^\d\d?\d?\.\d\d?\d?\.\d\d?\d?\.\d\d?\d?$/) {
      @Split = split(/\./, $CheckIP);
      if ($#Split == 3) {
         if (!(($Split[0] >= 1) && ($Split[0] <= 255))) {$Result = "0.0.0.0";}
         if (!(($Split[1] >= 0) && ($Split[1] <= 255))) {$Result = "0.0.0.0";}
         if (!(($Split[2] >= 0) && ($Split[2] <= 255))) {$Result = "0.0.0.0";}
         if (!(($Split[3] >= 0) && ($Split[3] <= 255))) {$Result = "0.0.0.0";}
      } else {$Result = "0.0.0.0";}
   } else {$Result = "0.0.0.0";}
   return $Result;
}



sub logging {
   my $logentry = shift;
   my $tty      = shift; $tty      = 0 if not defined $tty;      $tty      = 0 if $tty      !~ /^\d$/;
   my $RUNerror = shift; $RUNerror = 0 if not defined $RUNerror; $RUNerror = 0 if $RUNerror !~ /^\d$/;
   my $MESSlog  = shift; $MESSlog  = 0 if not defined $MESSlog;  $MESSlog  = 0 if $MESSlog  !~ /^\d$/;

   if ($logentry) {
      chomp($logentry);

      if ($MESSlog == 1) {
         if ((open(FILEOUTPUT, ">>$INI{'MESSFILE'}")) && ($infoMESS == 1)) {
            print FILEOUTPUT scalar localtime() . "  $logentry\n\n";
            close(FILEOUTPUT);
         }
         if ((open(FILEOUTPUT, ">>$INI{'LOGFILE'}")) && ($infoLOG == 1)) {
            print FILEOUTPUT "\n" . scalar localtime() . "  Message: $logentry\n\n";
            close(FILEOUTPUT);
         }
         print "\n" . scalar localtime() . "  Message: $logentry\n\n" if $Debug == 1;
         $logentry = "\n\n#####################################\n# Wichtige DynAccess-System Meldung #\n#     ".scalar localtime()."      #\n#####################################\n\n$logentry\n\n\n" if $INI{'LANGUAGE'} =~ /d/i;
         $logentry = "\n\n###################################\n# Urgent DynAccess-System Message #\n#    ".scalar localtime()."     #\n###################################\n\n$logentry\n\n\n"         if $INI{'LANGUAGE'} !~ /d/i;


         if ($infoTTY  == 1) {if ((-c "/dev/tty1")  && (open(TTY, ">>/dev/tty1")))  {print TTY $logentry; close(TTY);}}
         if ($infoTTY2 == 1) {if ((-c "/dev/tty2")  && (open(TTY, ">>/dev/tty2")))  {print TTY $logentry; close(TTY);}}
         if ($infoTTY2 == 1) {if ((-c "/dev/tty3")  && (open(TTY, ">>/dev/tty3")))  {print TTY $logentry; close(TTY);}}
         if ($infoTTY2 == 1) {if ((-c "/dev/tty4")  && (open(TTY, ">>/dev/tty4")))  {print TTY $logentry; close(TTY);}}
         if ($infoTTY2 == 1) {if ((-c "/dev/pts/0") && (open(TTY, ">>/dev/pts/0"))) {print TTY $logentry; close(TTY);}}
         if ($infoTTY2 == 1) {if ((-c "/dev/pts/1") && (open(TTY, ">>/dev/pts/1"))) {print TTY $logentry; close(TTY);}}
         if ($infoTTY2 == 1) {if ((-c "/dev/pts/2") && (open(TTY, ">>/dev/pts/2"))) {print TTY $logentry; close(TTY);}}
         if ($infoTTY2 == 1) {if ((-c "/dev/pts/3") && (open(TTY, ">>/dev/pts/3"))) {print TTY $logentry; close(TTY);}}

      } else {

         if (not defined $INI{'LOGSERVER'}) {$logentry = $1 if $logentry =~ /(.+?)\[.{7,15}\]/;}
         if (length($logentry) < 5) {
            $logentry = '';
         } else {
            $logentry = scalar localtime() . "  $logentry";
         }
         $logentry = "$logentry\n";

         if ($tty == -1) {
            if ($infoTTY  == 1) {if ((-c "/dev/tty1")  && (open(TTY, ">>/dev/tty1")))  {print TTY $logentry; close(TTY); $tty++;}}
         }
         if ($tty == 1) {
            if ($infoTTY  == 1) {if ((-c "/dev/tty1")  && (open(TTY, ">>/dev/tty1")))  {print TTY $logentry; close(TTY); $tty++;}}
            if ($infoTTY2 == 1) {if ((-c "/dev/tty2")  && (open(TTY, ">>/dev/tty2")))  {print TTY $logentry; close(TTY); $tty++;}}
            if ($infoTTY2 == 1) {if ((-c "/dev/tty3")  && (open(TTY, ">>/dev/tty3")))  {print TTY $logentry; close(TTY); $tty++;}}
            if ($infoTTY2 == 1) {if ((-c "/dev/tty4")  && (open(TTY, ">>/dev/tty4")))  {print TTY $logentry; close(TTY); $tty++;}}
            if ($infoTTY2 == 1) {if ((-c "/dev/pts/0") && (open(TTY, ">>/dev/pts/0"))) {print TTY $logentry; close(TTY); $tty++;}}
            if ($infoTTY2 == 1) {if ((-c "/dev/pts/1") && (open(TTY, ">>/dev/pts/1"))) {print TTY $logentry; close(TTY); $tty++;}}
            if ($infoTTY2 == 1) {if ((-c "/dev/pts/2") && (open(TTY, ">>/dev/pts/2"))) {print TTY $logentry; close(TTY); $tty++;}}
            if ($infoTTY2 == 1) {if ((-c "/dev/pts/3") && (open(TTY, ">>/dev/pts/3"))) {print TTY $logentry; close(TTY); $tty++;}}
         }
         if ($infoLOG == 1) {
            if (open(FILEOUTPUT, ">>$INI{'LOGFILE'}")) {
               print FILEOUTPUT $logentry;
               print            $logentry if $tty <= 1 && ($Debug == 1 || $Offline == 1);
               close(FILEOUTPUT);
            } else {
               print "\n\nSorry, kann Log-File in $INI{'LOGFILE'} nicht speichern!\n\n"  if $INI{'LANGUAGE'} =~ /d/i;
               print "\n\nSorry, could not save log-file in $INI{'LOGFILE'}!\n\n"        if $INI{'LANGUAGE'} !~ /d/i;
               $RUNerror = 1;
            }
         }
      }

      if ($RUNerror == 1) {
         print "\n\nT e r m i n a t i n g !\n\n";
         exit;
      }
   }
}

sub beep {
   $LastTry{'beep'} = time();
   if (($infoTTY == 1) && ($infoBEEP == 1)) {
      if (open(TTY, ">>/dev/tty1")) {
         print TTY chr(7);
         close(TTY);
      }
   }
}

sub OnlineHelp {

   my $topic = shift;
      $topic = "" if !$topic;

   my $year = scalar localtime();
      $year = $1 if $year =~ /(20\d\d)/;
      $year = "2004" if length($year) != 4;


   my $BuildDate = "          ";
      $BuildDate = "20$1-$2-$3" if                             $Build =~ /(\d{2})(\d{2})(\d{2})/;
      $BuildDate = "$3.$2.20$1" if $INI{'LANGUAGE'} =~ /d/i && $Build =~ /(\d{2})(\d{2})(\d{2})/ ;

   my $output = "";





my $OHintro = '';
if ($INI{'LANGUAGE'} =~ /d/) {
   $OHintro .= '###############################################################################'."\n";
   $OHintro .= '#                                                                             #'."\n";
   $OHintro .= '# Dieses Programm (DynAccessPoster) aktualisiert Ihren DynAccess-Account in   #'."\n";
   $OHintro .= '# regelmigem Intervall und stellt den perfekten Betrieb sicher.             #'."\n";
   $OHintro .= '# Da das DynAccess-System aus einer Vielzahl von Servern in unterschiedlichen #'."\n";
   $OHintro .= '# Rechenzentren besteht, sollten Sie wenn mglich auf dieses Programm         #'."\n";
   $OHintro .= '# oder unsere aktuelle Windows-Software zur Account-Aktualisierung            #'."\n";
   $OHintro .= '# zurckgreifen.                                                              #'."\n";
   $OHintro .= '# Denn nur unsere Account-Aktualisierungsprogramme stellen das perfekte       #'."\n";
   $OHintro .= '# Zusammenspiel zwischen Aktualisierungssoftware und DynAccess-System sicher. #'."\n";
   $OHintro .= '# Treten bei unseren Servern Probleme auf, so greifen unsere Programme        #'."\n";
   $OHintro .= '# automatisch auf Alternativ-Server zurck.                                   #'."\n";
   $OHintro .= '# So ist unsere Aktualisierungssoftware beispielsweise auch in der Lage,      #'."\n";
   $OHintro .= '# erfolgreiche Accountaktualisierungen durchzufhren, sollte es in Ihrem      #'."\n";
   $OHintro .= '# Netzwerk DNS-Probleme geben.                                                #'."\n";
   $OHintro .= '# Fremdprodukte oder DDNS-Untersttzungen in Hardwareroutern untersttzen zum #'."\n";
   $OHintro .= '# einen die Vielzahl unserer Features nicht, noch nutzen sie unsere           #'."\n";
   $OHintro .= '# redundant ausgelegten Systeme, ausser es liegt eine spezielle DynAccess-    #'."\n";
   $OHintro .= '# Integration vor (z.B. Lancom-Router).                                       #'."\n";
   $OHintro .= '#                                                                             #'."\n";
   $OHintro .= '# DynAccess ist ein B2B-Produkt, welches fr den gewerblichen Einsatz         #'."\n";
   $OHintro .= '# notwendige hchste Verfgbarkeit anstrebt und auf viele Eventualitten eine #'."\n";
   $OHintro .= '# Antwort parat hat.                                                          #'."\n";
   $OHintro .= '# So betrgt unsere Systemverfgbarkeit im 4-Jahresschnitt ber 99.9%         #'."\n";
   $OHintro .= '#                                                                             #'."\n";
   $OHintro .= '# Eine Online-Hilfe-bersicht erhalten Sie mittels                            #'."\n";
   $OHintro .= '#                                                                             #'."\n";
   $OHintro .= '#    bash:~ # perl DynAccessPoster.pl -h                                      #'."\n";
   $OHintro .= '# bzw.                                                                        #'."\n";
   $OHintro .= '#    bash:~ # ./DynAccessPoster -h                                            #'."\n";
   $OHintro .= '#                                                                             #'."\n";
   $OHintro .= '###############################################################################'."\n";
} else {
   $OHintro .= '###############################################################################'."\n";
   $OHintro .= '#                                                                             #'."\n";
   $OHintro .= '# This program (DynAccessPoster) updates your DynAccess account at regular    #'."\n";
   $OHintro .= '# intervals and ensures perfect operation.                                    #'."\n";
   $OHintro .= '# Since the DynAccess system consists of several servers at various computing #'."\n";
   $OHintro .= '# centres, if possible you should use this program or our current Windows     #'."\n";
   $OHintro .= '# software for account updates.                                               #'."\n";
   $OHintro .= '# For only our account-update program ensures perfect interaction between     #'."\n";
   $OHintro .= '# update software and DynAccess system.                                       #'."\n";
   $OHintro .= '# If problems occur with our servers, our programs automatically access       #'."\n";
   $OHintro .= '# backup servers.                                                             #'."\n";
   $OHintro .= '# Our update software is thus able to carry out successful account updates    #'."\n";
   $OHintro .= '# even if there are DNS problems in your network.                             #'."\n";
   $OHintro .= '# Third-party products or DDNS support in hardware routers do not support     #'."\n";
   $OHintro .= '# many of our features nor do they use our redundantly organised systems,     #'."\n";
   $OHintro .= '# unless there is special DynAccess support (e.g. Lancom router).             #'."\n";
   $OHintro .= '#                                                                             #'."\n";
   $OHintro .= '# DynAccess is a B2B product which aims for the highest availability for      #'."\n";
   $OHintro .= '# commercial use and has an answer for many eventualities.                    #'."\n";
   $OHintro .= '# Our system availability is thus more than 99.9% averaged over 4 years.      #'."\n";
   $OHintro .= '#                                                                             #'."\n";
   $OHintro .= '# An online-help overview is available via                                    #'."\n";
   $OHintro .= '#                                                                             #'."\n";
   $OHintro .= '#    bash:~ # perl DynAccessPoster.pl -h                                      #'."\n";
   $OHintro .= '# or                                                                          #'."\n";
   $OHintro .= '#    bash:~ # ./DynAccessPoster -h                                            #'."\n";
   $OHintro .= '#                                                                             #'."\n";
   $OHintro .= '###############################################################################'."\n";
}

my $OHhelp = '';
if ($INI{'LANGUAGE'} =~ /d/) {
   $OHhelp .= '###############################################################################'."\n";
   $OHhelp .= '#                            #                                                #'."\n";
   $OHhelp .= '#   Online-Hilfe-bersicht   #                                                #'."\n";
   $OHhelp .= '#                            #                                                #'."\n";
   $OHhelp .= '##############################                                                #'."\n";
   $OHhelp .= '#                                                                             #'."\n";
   $OHhelp .= '# Zur Konfiguration und zum Starten des Account-Aktualisierungsprogrammes     #'."\n";
   $OHhelp .= '# in verschiedenen Modi, stellen wir Ihnen verschiedene Informationen bereit  #'."\n";
   $OHhelp .= '# bereit, die Sie wie folgt abrufen knnen:                                   #'."\n";
   $OHhelp .= '#                                                                             #'."\n";
   $OHhelp .= '#    bash:~ # perl DynAccessPoster.pl <Online-Hilfe-Parameter>                #'."\n";
   $OHhelp .= '# bzw.                                                                        #'."\n";
   $OHhelp .= '#    bash:~ # ./DynAccessPoster <Online-Hilfe-Parameter>                      #'."\n";
   $OHhelp .= '#                                                                             #'."\n";
   $OHhelp .= '#    -h               Kurzhilfe mit bersicht der Hilfethemen                 #'."\n";
   $OHhelp .= '#    -h-all           Gesamthilfe                                             #'."\n";
   $OHhelp .= '#    -h-start         erweiterte Startoptionen                                #'."\n";
   $OHhelp .= '#    -h-configfile    Konfiguration ber /etc/DynAccessPoster.conf            #'."\n";
   $OHhelp .= '#    -h-configdirect  Konfiguration per Parameterbergabe beim Programmaufruf #'."\n";
   $OHhelp .= '#    -h-files         bersicht der Dateien, die der DynAccessPoster nutzt    #'."\n";
   $OHhelp .= '#    -h-advanced      advanced Parameter                                      #'."\n";
   $OHhelp .= '#    -h-md5           optionales MD5 fr mehr Passwort-Sicherheit             #'."\n";
   $OHhelp .= '#    -h-error         Fehlermeldungen und deren Bedeutung                     #'."\n";
   $OHhelp .= '#    -h-cron          CRON-Anwendungsbeispiel                                 #'."\n";
   $OHhelp .= '#    -v               Bildschirmausgabe von Version/AuthCode und Build        #'."\n";
   $OHhelp .= '###############################################################################'."\n";
} else {
   $OHhelp .= '###############################################################################'."\n";
   $OHhelp .= '#                            #                                                #'."\n";
   $OHhelp .= '#   online-help overview     #                                                #'."\n";
   $OHhelp .= '#                            #                                                #'."\n";
   $OHhelp .= '##############################                                                #'."\n";
   $OHhelp .= '#                                                                             #'."\n";
   $OHhelp .= '# For the configuration and startup of the account-update program in various  #'."\n";
   $OHhelp .= '# modes, we offer diverse information which you can access as follows:        #'."\n";
   $OHhelp .= '#                                                                             #'."\n";
   $OHhelp .= '#    bash:~ # perl DynAccessPoster.pl <online-help-parameters>                #'."\n";
   $OHhelp .= '# or                                                                          #'."\n";
   $OHhelp .= '#    bash:~ # ./DynAccessPoster <online-help-parameters>                      #'."\n";
   $OHhelp .= '#                                                                             #'."\n";
   $OHhelp .= '#    -h               short help with an overview of the help topics          #'."\n";
   $OHhelp .= '#    -h-all           entire help                                             #'."\n";
   $OHhelp .= '#    -h-start         advanced start options                                  #'."\n";
   $OHhelp .= '#    -h-configfile    configuration via /etc/DynAccessPoster.conf             #'."\n";
   $OHhelp .= '#    -h-configdirect  configuration via calling parameters                    #'."\n";
   $OHhelp .= '#    -h-files         overview of files used by DynAccessPoster               #'."\n";
   $OHhelp .= '#    -h-advanced      advanced parameters                                     #'."\n";
   $OHhelp .= '#    -h-md5           optional MD5 for more passwort security                 #'."\n";
   $OHhelp .= '#    -h-error         error messages and their meanings                       #'."\n";
   $OHhelp .= '#    -h-cron          example using CRON                                      #'."\n";
   $OHhelp .= '#    -v               screen display of version/AuthCode and build            #'."\n";
   $OHhelp .= '###############################################################################'."\n";
}

my $OHstart = '';
if ($INI{'LANGUAGE'} =~ /d/) {
   $OHstart .= '###############################################################################'."\n";
   $OHstart .= '#                              #                                              #'."\n";
   $OHstart .= '#   Erweiterte Startoptionen   #                                              #'."\n";
   $OHstart .= '#                              #                                              #'."\n";
   $OHstart .= '################################                                              #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# Durch die Angabe diverser Parameter beim Aufruf des DynAccessPosters,       #'."\n";
   $OHstart .= '# knnen Sie die grundlegende Funktionsweise des DynAccessPosters             #'."\n";
   $OHstart .= '# beeinflussen.                                                               #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '#     debug         Der DynAccessPoster startet im Debug-Modus (d.h. im       #'."\n";
   $OHstart .= '#                   Vordergrund) und gibt Informationen direkt auf der        #'."\n";
   $OHstart .= '#                   Konsole aus.                                              #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '#     force         Eine neue DynAccessPoster-Instanz wird erzwungen;         #'."\n";
   $OHstart .= '#                   bereits laufende beenden sich automatisch.                #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '#     offline       Die Offline-Schaltung wird aktiviert.                     #'."\n";
   $OHstart .= '#                   Der Poster baut eine Verbindung zum DynAccess-Account-    #'."\n";
   $OHstart .= '#                   Aktualisierungs-Server auf und veranlasst, dass der       #'."\n";
   $OHstart .= '#                   Account in den Offline-Modus geschaltet wird.             #'."\n";
   $OHstart .= '#                   Hiernach beendet sich der Poster.                         #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# Debug- oder Daemon-Modus:                                                   #'."\n";
   $OHstart .= '# ~~~~~~~~~~~~~~~~~~~~~~~~                                                    #'."\n";
   $OHstart .= '# Der DynAccessPoster schaltet sich nach dem Start sofort in den Daemon-Modus,#'."\n";
   $OHstart .= '# sofern Sie den Debug-Modus nicht mittels entsprechendem Parameter           #'."\n";
   $OHstart .= '# erzwingen.                                                                  #'."\n";
   $OHstart .= '# Daemon-Modus bedeutet, dass sich der DynAccessPoster in den Hintergrund     #'."\n";
   $OHstart .= '# schaltet und bis auf die Log-Eintrge keine Rckmeldungen gibt.             #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# Starten Sie den DynAccessPoster im Debug-Modus mittels                      #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '#    bash:~ # perl DynAccessPoster.pl debug                                   #'."\n";
   $OHstart .= '# bzw.                                                                        #'."\n";
   $OHstart .= '#    bash:~ # ./DynAccessPoster debug                                         #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# wird es sich nun nicht sofort in den Hintergrund schalten.                  #'."\n";
   $OHstart .= '# Der DynAccessPoster luft im Debug-Modus (d.h. im Vordergrund) und gibt     #'."\n";
   $OHstart .= '# smtliche Informationen, die ins Log geschrieben werden, auch direkt am     #'."\n";
   $OHstart .= '# Bildschirm aus.                                                             #'."\n";
   $OHstart .= '# Luft bereits eine Instanz des DynAccessPosters im Daemon-Modus und Sie     #'."\n";
   $OHstart .= '# starten den DynAccessPoster zustzlich im Debug-Modus, beendet sich der     #'."\n";
   $OHstart .= '# DynAccessPoster, welcher bereits im Daemon-Modus luft.                     #'."\n";
   $OHstart .= '# Es laufen niemals zwei DynAccessPoster parallel nebeneinander her, sofern   #'."\n";
   $OHstart .= '# Sie diesen DynAccessPoster auf einem Linux-/UNIX-System einsetzen.          #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# Neue DynAccessPoster-Instanz erzwingen:                                     #'."\n";
   $OHstart .= '# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                                     #'."\n";
   $OHstart .= '# Starten Sie den Client mittels                                              #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '#    bash:~ # perl DynAccessPoster.pl                                         #'."\n";
   $OHstart .= '# bzw.                                                                        #'."\n";
   $OHstart .= '#    bash:~ # ./DynAccessPoster                                               #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# mehrfach, so hat dies unter einem Linux-/UNIX-System keine Auswirkung, da   #'."\n";
   $OHstart .= '# der neu gestartete DynAccessPoster eine bereits laufende Instanz erkennen   #'."\n";
   $OHstart .= '# kann und sich daraufhin selbstndig beendet.                                #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# Mittels                                                                     #'."\n";
   $OHstart .= '#    bash:~ # perl DynAccessPoster.pl force                                   #'."\n";
   $OHstart .= '# bzw.                                                                        #'."\n";
   $OHstart .= '#    bash:~ # ./DynAccessPoster force                                         #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# knnen Sie eine neue DynAccessPoster-Instanz erzwingen. Bereits laufende    #'."\n";
   $OHstart .= '# werden sich automatisch beenden.                                            #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# Kontrollierte Offline-Schaltung:                                            #'."\n";
   $OHstart .= '# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                                            #'."\n";
   $OHstart .= '# Rufen Sie den DynAccessPoster wie folgt auf                                 #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '#    bash:~ # perl DynAccessPoster.pl offline                                 #'."\n";
   $OHstart .= '# bzw.                                                                        #'."\n";
   $OHstart .= '#    bash:~ # ./DynAccessPoster offline                                       #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# fhrt dies dazu, dass Ihr DynAccess-Account neutralisiert wird, d.h. dass   #'."\n";
   $OHstart .= '# Ihr Account mit einer neutralen IP konfiguriert wird.                       #'."\n";
   $OHstart .= '# Ferner beenden sich alle DynAccessPoster-Instanzen.                         #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# Sinnvoll ist dies, wenn Sie kontrolliert offline gehen und Ihren DynAccess- #'."\n";
   $OHstart .= '# Account neutralisieren mchten.                                             #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '###############################################################################'."\n";
} else {
   $OHstart .= '###############################################################################'."\n";
   $OHstart .= '#                              #                                              #'."\n";
   $OHstart .= '#   advanced start options     #                                              #'."\n";
   $OHstart .= '#                              #                                              #'."\n";
   $OHstart .= '################################                                              #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# You can influence the basic functioning of DynAccessPoster via diverse      #'."\n";
   $OHstart .= '# calling parameters.                                                         #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '#     debug         DynAccessPoster starts in debug mode (i.e. in the         #'."\n";
   $OHstart .= '#                   foreground) and prints information directly to the        #'."\n";
   $OHstart .= '#                   console                                                   #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '#     force         A new instance of DynAccessPoster is created; those       #'."\n";
   $OHstart .= '#                   already running are terminated automatically.             #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '#     offline       The offline configuration is activated.                   #'."\n";
   $OHstart .= '#                   The poster sets up a connection to the DynAccess          #'."\n";
   $OHstart .= '#                   account-update server and causes the account to be        #'."\n";
   $OHstart .= '#                   configured in offline mode.                               #'."\n";
   $OHstart .= '#                   After that, DynAccessPoster terminates.                   #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# Debug- or daemon mode:                                                      #'."\n";
   $OHstart .= '# ~~~~~~~~~~~~~~~~~~~~~~~~                                                    #'."\n";
   $OHstart .= '# DynAccessPoster switches to daemon mode immediately after startup as long   #'."\n";
   $OHstart .= '# as debug mode is not forced via the corresponding parameter.                #'."\n";
   $OHstart .= '# Daemon mode means that DynAccessPoster switches into the background and,    #'."\n";
   $OHstart .= '# except for log-file entries, produces no output.                            #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# If you start DynAccessPoster in debug mode via                              #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '#    bash:~ # perl DynAccessPoster.pl debug                                   #'."\n";
   $OHstart .= '# or                                                                          #'."\n";
   $OHstart .= '#    bash:~ # ./DynAccessPoster debug                                         #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# then it will not switch to the background immediately.                      #'."\n";
   $OHstart .= '# DynAccessPoster runs in debug mode (i.e. in the foreground) and prints out  #'."\n";
   $OHstart .= '# directly to the screen all the information which is also written into the   #'."\n";
   $OHstart .= '# log file.                                                                   #'."\n";
   $OHstart .= '# If an instance of DynAccessPoster is already running in daemon mode and you #'."\n";
   $OHstart .= '# start another instance of DynAccessPoster in debug mode, then the           #'."\n";
   $OHstart .= '# DynAccessPoster which is already running in daemon mode terminates.         #'."\n";
   $OHstart .= '# Two instances of DynAccessPoster never run in parallel as long as you use   #'."\n";
   $OHstart .= '# DynAccessPoster on a Linux/UNIX system.                                     #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# Force a new instance of DynAccessPoster:                                    #'."\n";
   $OHstart .= '# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                                     #'."\n";
   $OHstart .= '# If you start the client via                                                 #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '#    bash:~ # perl DynAccessPoster.pl                                         #'."\n";
   $OHstart .= '# or                                                                          #'."\n";
   $OHstart .= '#    bash:~ # ./DynAccessPoster                                               #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# more than once, this has no effect on a Linux/UNIX system since the newly   #'."\n";
   $OHstart .= '# started DynAccessPoster notices an already running instance and terminates  #'."\n";
   $OHstart .= '# itself.                                                                     #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# Via                                                                         #'."\n";
   $OHstart .= '#    bash:~ # perl DynAccessPoster.pl force                                   #'."\n";
   $OHstart .= '# or                                                                          #'."\n";
   $OHstart .= '#    bash:~ # ./DynAccessPoster force                                         #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# you can force a new instance of DynAccessPoster.  Those already running     #'."\n";
   $OHstart .= '# will terminate automatically.                                               #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# Controlled offline-switching:                                               #'."\n";
   $OHstart .= '# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                                            #'."\n";
   $OHstart .= '# If you call DynAccessPoster as follows                                      #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '#    bash:~ # perl DynAccessPoster.pl offline                                 #'."\n";
   $OHstart .= '# or                                                                          #'."\n";
   $OHstart .= '#    bash:~ # ./DynAccessPoster offline                                       #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# then this leads to the neutralisation of your DynAccess account, i.e. your  #'."\n";
   $OHstart .= '# account is configured with a neutral IP.                                    #'."\n";
   $OHstart .= '# In addition, all instances of DynAccessPoster terminate.                    #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '# This makes sense when you want to go offline in a controlled manner and     #'."\n";
   $OHstart .= '# would like to neutralise your DynAccess account.                            #'."\n";
   $OHstart .= '#                                                                             #'."\n";
   $OHstart .= '###############################################################################'."\n";
}

my $OHconfigfile = '';
if ($INI{'LANGUAGE'} =~ /d/) {
   $OHconfigfile .= '###############################################################################'."\n";
   $OHconfigfile .= '#                                    #                                        #'."\n";
   $OHconfigfile .= '#   Konfiguration                    #                                        #'."\n";
   $OHconfigfile .= '#   ber /etc/DynAccessPoster.conf   #                                        #'."\n";
   $OHconfigfile .= '#                                    #                                        #'."\n";
   $OHconfigfile .= '######################################                                        #'."\n";
   $OHconfigfile .= '#                                                                             #'."\n";
   $OHconfigfile .= '# Die Konfiguration erfolgt ber die Datei /etc/DynAccessPoster.conf, sofern  #'."\n";
   $OHconfigfile .= '# Sie die Konfiguration nicht per Parameterbergabe direkt beim Programm-     #'."\n";
   $OHconfigfile .= '# aufruf durchfhren.                                                         #'."\n";
   $OHconfigfile .= '# Ist die Datei /etc/DynAccessPoster.conf nicht vorhanden, wird sie vom       #'."\n";
   $OHconfigfile .= '# DynAccessPoster nach dem erstmaligen Starten automatisch angelegt.          #'."\n";
   $OHconfigfile .= '# Hiernach beendet sich der DynAccessPoster und fordert Sie zur Konfiguration #'."\n";
   $OHconfigfile .= '# auf.                                                                        #'."\n";
   $OHconfigfile .= '# Kann die Datei /etc/DynAccessPoster.conf nicht angelegt werden, empfiehlt   #'."\n";
   $OHconfigfile .= '# sich je nach Ihrer Betriebsystem-Konfiguration die Konfiguration des        #'."\n";
   $OHconfigfile .= '# DynAccess-Account-Aktualisierungsprogrammes mittels der direkten            #'."\n";
   $OHconfigfile .= '# Parameterbergabe.                                                          #'."\n";
   $OHconfigfile .= '#                                                                             #'."\n";
   $OHconfigfile .= '# Neben der Angabe des Accountnamens (z.B. meinAccount), der Domain           #'."\n";
   $OHconfigfile .= '# unterhalb derer Sie Ihren Account angelegt haben (z.B. dynaccess.de),       #'."\n";
   $OHconfigfile .= '# sowie des Passwortes, knnen Sie noch folgendes konfigurieren:              #'."\n";
   $OHconfigfile .= '#                                                                             #'."\n";
   $OHconfigfile .= '# Language     = [de|en] Sprache der Meldungen auf der Konsole bzw. im Log    #'."\n";
   $OHconfigfile .= '#                        default: en                                          #'."\n";
   $OHconfigfile .= '# UseHeartBeat = [0|1]   Haben Sie einen HeartBeat-Account, knnen Sie die    #'."\n";
   $OHconfigfile .= '#                        Verwendung des HeartBeats aktivieren/deaktivieren.   #'."\n";
   $OHconfigfile .= '#                        default: 1 (d.h. aktiviert)                          #'."\n";
   $OHconfigfile .= '# LogHeartBeat = [0|1]   Sie knnen sich auf Wunsch im Log das Senden eines   #'."\n";
   $OHconfigfile .= '#                        jeden HeartBeats protokollieren lassen.              #'."\n";
   $OHconfigfile .= '#                        default: 0 (d.h. deaktiviert und ratsam)             #'."\n";
   $OHconfigfile .= '# LogMyIP      = [0|1]   Sie knnen sich auf Wunsch im Log das berprfen     #'."\n";
   $OHconfigfile .= '#                        Ihrer dynamischen IP (myIP) protokollieren lassen.   #'."\n";
   $OHconfigfile .= '#                        Bei LogMyIP = 0 werden lediglich Fehler und IP-      #'."\n";
   $OHconfigfile .= '#                        Wechsel protokolliert.                               #'."\n";
   $OHconfigfile .= '#                        default: 0 (d.h. deaktiviert)                        #'."\n";
   $OHconfigfile .= '# LogSetIP     = [0|1]   Sie knnen sich auf Wunsch im Log die Informationen, #'."\n";
   $OHconfigfile .= '#                        die dieser Client von unseren Servern nach einer     #'."\n";
   $OHconfigfile .= '#                        Account-Aktualisierung erhlt, anzeigen lassen.      #'."\n";
   $OHconfigfile .= '#                        Per default wird lediglich der Hinweis auf eine      #'."\n";
   $OHconfigfile .= '#                        erfolgreiche Account-Aktualisierung protokolliert.   #'."\n";
   $OHconfigfile .= '#                        default: 0 (d.h. Standardinfo)                       #'."\n";
   $OHconfigfile .= '# LogServer    = [0|1]   Im Log knnen Sie sich den Server, auf den der       #'."\n";
   $OHconfigfile .= '#                        Client zugreift, protokollieren lassen.              #'."\n";
   $OHconfigfile .= '#                        Die IP des DynAccess-Servers wird im Log in eckigen  #'."\n";
   $OHconfigfile .= '#                        Klammern angegeben.                                  #'."\n";
   $OHconfigfile .= '#                        default: 1 (d.h. aktiviert)                          #'."\n";
   $OHconfigfile .= '#                                                                             #'."\n";
   $OHconfigfile .= '# Bei Linux-/UNIX-Systemen wird eine nderung der Konfiguration in            #'."\n";
   $OHconfigfile .= '# /etc/DynAccessPoster.conf vom Client zur Laufzeit erkannt und binnen        #'."\n";
   $OHconfigfile .= '# weniger Sekunden bernommen, wodurch auch ein Account-Aktualisierung        #'."\n";
   $OHconfigfile .= '# ausgelst wird.                                                             #'."\n";
   $OHconfigfile .= '# Ein DynAccessPoster Neustart nach einer Konfigurationsnderung ist somit    #'."\n";
   $OHconfigfile .= '# bei Linux-/UNIX-Systemen nicht erforderlich.                                #'."\n";
   $OHconfigfile .= '#                                                                             #'."\n";
   $OHconfigfile .= '#                                                                             #'."\n";
   $OHconfigfile .= '# Die weitere DynAccess-Account-Konfiguration, d.h. die Konfiguration der     #'."\n";
   $OHconfigfile .= '# Features, nehmen Sie bitte via http://myaccount.dynaccess.de vor.           #'."\n";
   $OHconfigfile .= '# Das Eingabefeld "Ablaufzeit" unter http://myaccount.dynaccess.de findet bei #'."\n";
   $OHconfigfile .= '# Verwendung dieses DynAccessPosters keine Anwendung, da die Ablaufzeit von   #'."\n";
   $OHconfigfile .= '# diesem Programm gesteuert wird und gem Ihres gewhlten Tarifes auf den    #'."\n";
   $OHconfigfile .= '# minimalen und somit optimalen Wert gesetzt wird.                            #'."\n";
   $OHconfigfile .= '#                                                                             #'."\n";
   $OHconfigfile .= '###############################################################################'."\n";
} else {
   $OHconfigfile .= '###############################################################################'."\n";
   $OHconfigfile .= '#                                    #                                        #'."\n";
   $OHconfigfile .= '#   configuration                    #                                        #'."\n";
   $OHconfigfile .= '#   via /etc/DynAccessPoster.conf    #                                        #'."\n";
   $OHconfigfile .= '#                                    #                                        #'."\n";
   $OHconfigfile .= '######################################                                        #'."\n";
   $OHconfigfile .= '#                                                                             #'."\n";
   $OHconfigfile .= '# The configuration takes place via the file /etc/DynAccessPoster.conf as     #'."\n";
   $OHconfigfile .= '# long as you don\'t carry out the configuration directly via calling          #'."\n";
   $OHconfigfile .= '# parameters.                                                                 #'."\n";
   $OHconfigfile .= '# If the file /etc/DynAccessPoster does not exist, it is created              #'."\n";
   $OHconfigfile .= '# automatically by DynAccessPoster after the first startup.                   #'."\n";
   $OHconfigfile .= '# Afterwards, DynAccessPoster terminates and requests that you configure it.  #'."\n";
   $OHconfigfile .= '# If the file /etc/DynAccessPoster cannot be created, then depending on your  #'."\n";
   $OHconfigfile .= '# operating-system configuration it is recommended to carry out the           #'."\n";
   $OHconfigfile .= '# configuration of the DynAccess account-update program directly via calling  #'."\n";
   $OHconfigfile .= '# parameters.                                                                 #'."\n";
   $OHconfigfile .= '#                                                                             #'."\n";
   $OHconfigfile .= '# In addition to the account name (e.g. myAccount), the domain under which    #'."\n";
   $OHconfigfile .= '# your account is set up (e.g. dynaccess.com) and the password, you can       #'."\n";
   $OHconfigfile .= '# configure the following:                                                    #'."\n";
   $OHconfigfile .= '#                                                                             #'."\n";
   $OHconfigfile .= '# Language     = [de|en] language for the messages to the console and in the  #'."\n";
   $OHconfigfile .= '#                        log                                                  #'."\n";
   $OHconfigfile .= '#                        default: en                                          #'."\n";
   $OHconfigfile .= '# UseHeartBeat = [0|1]   If you have a HeartBeat account, you can activate or #'."\n";
   $OHconfigfile .= '#                        deactivate the use of the HeartBeat.                 #'."\n";
   $OHconfigfile .= '#                        default: 1 (i.e. activated)                          #'."\n";
   $OHconfigfile .= '# LogHeartBeat = [0|1]   If desired, you can record the transmission of       #'."\n";
   $OHconfigfile .= '#                        each heartbeat in the log                            #'."\n";
   $OHconfigfile .= '#                        default: 0 (i.e. deactivated and recommended)        #'."\n";
   $OHconfigfile .= '# LogMyIP      = [0|1]   If desired, you can record the testing of your       #'."\n";
   $OHconfigfile .= '#                        dynamic IP (myIP) in the log.                        #'."\n";
   $OHconfigfile .= '#                        For LogMyIP = 0 only errors and IP changes are       #'."\n";
   $OHconfigfile .= '#                        recorded.                                            #'."\n";
   $OHconfigfile .= '#                        default: 0 (i.e. deactivated)                        #'."\n";
   $OHconfigfile .= '# LogSetIP     = [0|1]   If desired, you can list in the log the information  #'."\n";
   $OHconfigfile .= '#                        which this client receives from our servers after    #'."\n";
   $OHconfigfile .= '#                        an account update.                                   #'."\n";
   $OHconfigfile .= '#                        By default, only the fact that the account update    #'."\n";
   $OHconfigfile .= '#                        was successful is recorded.                          #'."\n";
   $OHconfigfile .= '#                        default: 0 (i.e. standard info)                      #'."\n";
   $OHconfigfile .= '# LogServer    = [0|1]   You can record in the log the server which was       #'."\n";
   $OHconfigfile .= '#                        accessed by the client.                              #'."\n";
   $OHconfigfile .= '#                        The IP of the DynAccess server is listed in the log  #'."\n";
   $OHconfigfile .= '#                        in square brackets.                                  #'."\n";
   $OHconfigfile .= '#                        default: 1 (i.e. activated)                          #'."\n";
   $OHconfigfile .= '#                                                                             #'."\n";
   $OHconfigfile .= '# On Linux/UNIX systems, a change in the configuration in                     #'."\n";
   $OHconfigfile .= '# /etc/DynAccessPoster.conf is noticed by the client at run-time and taken    #'."\n";
   $OHconfigfile .= '# into account within a few seconds, which also causes an account update.     #'."\n";
   $OHconfigfile .= '# A restart of DynAccessPoster after a configuration change is thus not       #'."\n";
   $OHconfigfile .= '# necessary on Linux/UNIX systems.                                            #'."\n";
   $OHconfigfile .= '#                                                                             #'."\n";
   $OHconfigfile .= '#                                                                             #'."\n";
   $OHconfigfile .= '# Further DynAccess account configuration, i.e. the configuration of the      #'."\n";
   $OHconfigfile .= '# features, should be done via http://myaccount.dynaccess.com.                #'."\n";
   $OHconfigfile .= '# The entry field "expiration time" at http://myaccount.dynaccess.com is not  #'."\n";
   $OHconfigfile .= '# used if DynAccessPoster is used since the expiration time is controlled     #'."\n";
   $OHconfigfile .= '# from this program and the minimal and thus optimal value allowed by your    #'."\n";
   $OHconfigfile .= '# tariff is set.                                                              #'."\n";
   $OHconfigfile .= '#                                                                             #'."\n";
   $OHconfigfile .= '###############################################################################'."\n";
}

my $OHconfigdirect = '';
if ($INI{'LANGUAGE'} =~ /d/) {
   $OHconfigdirect .= '###############################################################################'."\n";
   $OHconfigdirect .= '#                                                   #                         #'."\n";
   $OHconfigdirect .= '#   direkte Konfiguration per                       #                         #'."\n";
   $OHconfigdirect .= '#   Parameterbergabe beim DynAccessPoster Aufruf   #                         #'."\n";
   $OHconfigdirect .= '#                                                   #                         #'."\n";
   $OHconfigdirect .= '#####################################################                         #'."\n";
   $OHconfigdirect .= '#                                                                             #'."\n";
   $OHconfigdirect .= '# Neben der Konfiguration des DynAccessPosters via /etc/DynAccessPoster.conf  #'."\n";
   $OHconfigdirect .= '# knnen Sie die Konfiguration auch beim Programmaufruf durch direkte         #'."\n";
   $OHconfigdirect .= '# Parameterbergabe durchfhren.                                              #'."\n";
   $OHconfigdirect .= '#                                                                             #'."\n";
   $OHconfigdirect .= '# Existiert die Konfigurationsdatei /etc/DynAccessPoster.conf, so werden die  #'."\n";
   $OHconfigdirect .= '# dort vorgenommenen Konfigurationen verwendet und ggf. durch die             #'."\n";
   $OHconfigdirect .= '# abweichende direkte Konfiguration per Parameterbergabe berschrieben.      #'."\n";
   $OHconfigdirect .= '# Die direkte Konfiguration mittels Parameterbergabe hat somit der           #'."\n";
   $OHconfigdirect .= '# Konfiguration via /etc/DynAccessPoster.conf Vorrang, wobei eine Misch-      #'."\n";
   $OHconfigdirect .= '# konfiguration mglich ist.                                                  #'."\n";
   $OHconfigdirect .= '# Mchten Sie die Konfiguration via /etc/DynAccessPoster.conf komplett        #'."\n";
   $OHconfigdirect .= '# unterbinden, geben Sie zustzlich den Parameter noCONFfile beim Start des   #'."\n";
   $OHconfigdirect .= '# DynAccessPosters an. So unterbinden Sie auch das automatische Anlegen der   #'."\n";
   $OHconfigdirect .= '# Datei /etc/DynAccessPoster.conf durch den DynAccessPoster.                  #'."\n";
   $OHconfigdirect .= '#                                                                             #'."\n";
   $OHconfigdirect .= '#     --Account=    Geben Sie hier Ihren Accountnamen ohne die nachgestellte  #'."\n";
   $OHconfigdirect .= '#                   Domain (z.B. dynaccess.de) an.                            #'."\n";
   $OHconfigdirect .= '#                     Beispiel: --Account=test                                #'."\n";
   $OHconfigdirect .= '#                                                                             #'."\n";
   $OHconfigdirect .= '#     --Domain=     Geben Sie hier den Domainnamen (z.B. dynaccess.de) an,    #'."\n";
   $OHconfigdirect .= '#                   unterhalb derer Sie Ihren DynAccess-Account haben.        #'."\n";
   $OHconfigdirect .= '#                     Beispiel: --Domain=dynaccess.de                         #'."\n";
   $OHconfigdirect .= '#                                                                             #'."\n";
   $OHconfigdirect .= '#     --Hostname=   Optional knnen Sie statt der Angabe von --Account und    #'."\n";
   $OHconfigdirect .= '#                   --Domain dies komplett ber einen Parameter und Ihrem     #'."\n";
   $OHconfigdirect .= '#                   FQDN (Fully Qualified Domain Name - Eindeutiger Name      #'."\n";
   $OHconfigdirect .= '#                   eines Internet-Hosts) angeben.                            #'."\n";
   $OHconfigdirect .= '#                      Entweder:   --Account=test --Domain=dynaccess.de       #'."\n";
   $OHconfigdirect .= '#                      oder    :   --hostname=test.dynaccess.de               #'."\n";
   $OHconfigdirect .= '#                                                                             #'."\n";
   $OHconfigdirect .= '#     --Passwd=     geben Sie hier Ihr Passwort im Klartext oder              #'."\n";
   $OHconfigdirect .= '#                   vorzugsweise MD5-verschlsselt an, welches Sie via        #'."\n";
   $OHconfigdirect .= '#                   http://myaccount.dynaccess.de erhalten knnen.            #'."\n";
   $OHconfigdirect .= '#                                                                             #'."\n";
   $OHconfigdirect .= '#     --Language=[de|en]   \                                                  #'."\n";
   $OHconfigdirect .= '#     --UseHeartBeat=[0|1]  \   Die Konfiguration der Parameter, wie Sie sie  #'."\n";
   $OHconfigdirect .= '#     --LogHeartBeat=[0|1]  |   im Konfigurationsfile vornehmen knnen, ist   #'."\n";
   $OHconfigdirect .= '#     --LogMyIP=[0|1]       |   ber eine direkte Parameter-Werte-bergabe    #'."\n";
   $OHconfigdirect .= '#     --LogSetIP=[0|1]      /   mglich.                                      #'."\n";
   $OHconfigdirect .= '#     --LogServer=[0|1]    /                                                  #'."\n";
   $OHconfigdirect .= '#                                                                             #'."\n";
   $OHconfigdirect .= '#                                                                             #'."\n";
   $OHconfigdirect .= '#     --PidFile=   \                                                          #'."\n";
   $OHconfigdirect .= '#     --LogFile=   | Der Pfad der jeweiligen Datei kann gendert werden       #'."\n";
   $OHconfigdirect .= '#     --MessFile=  /                                                          #'."\n";
   $OHconfigdirect .= '#                                                                             #'."\n";
   $OHconfigdirect .= '###############################################################################'."\n";
} else {
   $OHconfigdirect .= '###############################################################################'."\n";
   $OHconfigdirect .= '#                                                   #                         #'."\n";
   $OHconfigdirect .= '#   direct configuration via                        #                         #'."\n";
   $OHconfigdirect .= '#   calling parameters                              #                         #'."\n";
   $OHconfigdirect .= '#                                                   #                         #'."\n";
   $OHconfigdirect .= '#####################################################                         #'."\n";
   $OHconfigdirect .= '#                                                                             #'."\n";
   $OHconfigdirect .= '# In addition to configuring DynAccessPoster via /etc/DynAccessPoster.conf,   #'."\n";
   $OHconfigdirect .= '# you can carry out the configuration directly via calling parameters.        #'."\n";
   $OHconfigdirect .= '#                                                                             #'."\n";
   $OHconfigdirect .= '# If the configuration file /etc/DynAccessPoster.conf exists, then the        #'."\n";
   $OHconfigdirect .= '# corresponding configuration is used but aspects which are specified         #'."\n";
   $OHconfigdirect .= '# differently in the calling parameters are overwritten.                      #'."\n";
   $OHconfigdirect .= '# Direct configuration via the calling parameters thus takes precedence over  #'."\n";
   $OHconfigdirect .= '# the configuration via /etc/DynAccessPoster.conf, although a mixed           #'."\n";
   $OHconfigdirect .= '# configuration is possible.                                                  #'."\n";
   $OHconfigdirect .= '# If you wish to completely suppress the configuration via                    #'."\n";
   $OHconfigdirect .= '# /etc/DynAccessPoster.conf, then additionally specify the parameter          #'."\n";
   $OHconfigdirect .= '# noCONFfile when starting DynAccessPoster.  This also suppressess the        #'."\n";
   $OHconfigdirect .= '# automatic configuration of the file /etc/DynAccessPoster.conf via           #'."\n";
   $OHconfigdirect .= '# DynAccessPoster.                                                            #'."\n";
   $OHconfigdirect .= '#                                                                             #'."\n";
   $OHconfigdirect .= '#     --Account=    Specify your account name here, without the following     #'."\n";
   $OHconfigdirect .= '#                   Domain (e.g. dynaccess.com).                              #'."\n";
   $OHconfigdirect .= '#                     example: --Account=test                                 #'."\n";
   $OHconfigdirect .= '#                                                                             #'."\n";
   $OHconfigdirect .= '#     --Domain=     Specify your domain name (e.g. dynaccess.com) under which #'."\n";
   $OHconfigdirect .= '#                   you have your DynAccess account.                          #'."\n";
   $OHconfigdirect .= '#                     example: --Domain=dynaccess.com                         #'."\n";
   $OHconfigdirect .= '#                                                                             #'."\n";
   $OHconfigdirect .= '#     --Hostname=   Optionally, instead of specifying --Account and --Domain, #'."\n";
   $OHconfigdirect .= '#                   you can specify this via one parameter and your FQDN      #'."\n";
   $OHconfigdirect .= '#                   (Fully Qualified Domain Name).                            #'."\n";
   $OHconfigdirect .= '#                      either:   --Account=test --Domain=dynaccess.com        #'."\n";
   $OHconfigdirect .= '#                      or    :   --hostname=test.dynaccess.com                #'."\n";
   $OHconfigdirect .= '#                                                                             #'."\n";
   $OHconfigdirect .= '#     --Passwd=     Specify your password here in plain text or preferably    #'."\n";
   $OHconfigdirect .= '#                   MD5-encoded, which can be obtained from                   #'."\n";
   $OHconfigdirect .= '#                   http://myaccount.dynaccess.com.                           #'."\n";
   $OHconfigdirect .= '#                                                                             #'."\n";
   $OHconfigdirect .= '#     --Language=[de|en]   \                                                  #'."\n";
   $OHconfigdirect .= '#     --UseHeartBeat=[0|1]  \   Configuration of the parameters like you can  #'."\n";
   $OHconfigdirect .= '#     --LogHeartBeat=[0|1]  |   do in the configuration file is also          #'."\n";
   $OHconfigdirect .= '#     --LogMyIP=[0|1]       |   possible directly via calling parameters.     #'."\n";
   $OHconfigdirect .= '#     --LogSetIP=[0|1]      /                                                 #'."\n";
   $OHconfigdirect .= '#     --LogServer=[0|1]    /                                                  #'."\n";
   $OHconfigdirect .= '#                                                                             #'."\n";
   $OHconfigdirect .= '#                                                                             #'."\n";
   $OHconfigdirect .= '#     --PidFile=   \                                                          #'."\n";
   $OHconfigdirect .= '#     --LogFile=   | The path to the corresponding file can be changed.       #'."\n";
   $OHconfigdirect .= '#     --MessFile=  /                                                          #'."\n";
   $OHconfigdirect .= '#                                                                             #'."\n";
   $OHconfigdirect .= '###############################################################################'."\n";
}

my $OHfiles = '';
if ($INI{'LANGUAGE'} =~ /d/) {
   $OHfiles .= '###############################################################################'."\n";
   $OHfiles .= '#                               #                                             #'."\n";
   $OHfiles .= '#   weitere DynAccess-Dateien   #                                             #'."\n";
   $OHfiles .= '#                               #                                             #'."\n";
   $OHfiles .= '#################################                                             #'."\n";
   $OHfiles .= '#                                                                             #'."\n";
   $OHfiles .= '#   Das Script schreibt folgende Dateien:                                     #'."\n";
   $OHfiles .= '#                                                                             #'."\n";
   $OHfiles .= '#   Pid-File: /var/run/DynAccessPoster.pid                                    #'."\n";
   $OHfiles .= '#   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                                    #'."\n";
   $OHfiles .= '#   In diese Datei wird die aktuelle Prozess-ID hineingeschrieben. Dies ist   #'."\n";
   $OHfiles .= '#   insbesondere dafr relevant, als das Sie den DynAccessPoster mehrfach     #'."\n";
   $OHfiles .= '#   starten knnen. Jede zustzliche Programminstanz beendet sich             #'."\n";
   $OHfiles .= '#   selbstndig, wenn sie feststellt, dass bereits ein DynAccessPoster luft. #'."\n";
   $OHfiles .= '#   Ein Lschen dieser Datei bewirkt das sich automatische Beenden des        #'."\n";
   $OHfiles .= '#   DynAccessPosters.                                                         #'."\n";
   $OHfiles .= '#   Sie knnen ber die Config-Datei den Ort des Pid-Files ber den Parameter #'."\n";
   $OHfiles .= '#   PidFile ndern.                                                           #'."\n";
   $OHfiles .= '#   z.B. PidFile: /etc/DynAccess.pid                                          #'."\n";
   $OHfiles .= '#                                                                             #'."\n";
   $OHfiles .= '#                                                                             #'."\n";
   $OHfiles .= '#   Log-File: /var/log/DynAccessPoster.log                                    #'."\n";
   $OHfiles .= '#   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                                    #'."\n";
   $OHfiles .= '#   In dieser Datei wird das Log geschrieben. Sie sollten hierauf zu Beginn   #'."\n";
   $OHfiles .= '#   des Einsatzes des DynAccessPosters unbedingt ein besonderes Auge haben.   #'."\n";
   $OHfiles .= '#   Sollte sich Ihre InterNet-Verbindung im oberen Lastbereich befinden, so   #'."\n";
   $OHfiles .= '#   ist es mglich, dass das Protokoll mit zahlreichen Fehlermeldungen        #'."\n";
   $OHfiles .= '#   versehen ist. Kurzfristig stellt dies absolut kein Problem da.            #'."\n";
   $OHfiles .= '#   Das Script versucht im Fehlerfall permanent in kurzen Intervallen eine    #'."\n";
   $OHfiles .= '#   erfolgreiche Aktualisierung durchzufhren. Vergleichen Sie dieses         #'."\n";
   $OHfiles .= '#   Protokoll auch mit dem Protokoll Ihres DynAccess-Accounts unseres         #'."\n";
   $OHfiles .= '#   Servers unter http://myaccount.dynaccess.de                               #'."\n";
   $OHfiles .= '#   Ein Dauerzustand sollten wiederholte Fehlermeldungen im Log auf keinen    #'."\n";
   $OHfiles .= '#   Fall sein.                                                                #'."\n";
   $OHfiles .= '#   Sollten Programme wie "eDonkey" o.. laufen, limitieren sie bitte up- und #'."\n";
   $OHfiles .= '#   download, um auch dem DynAccessPoster gengend Bandbreite fr             #'."\n";
   $OHfiles .= '#   problemlose Account-Aktualisierungen zu geben. Dies ist insbesondere beim #'."\n";
   $OHfiles .= '#   HeartBeat-Einsatz, wo verbindungslose UDP-Pakete gesendet werden, zu      #'."\n";
   $OHfiles .= '#   beachten.                                                                 #'."\n";
   $OHfiles .= '#   Sie knnen ber die Config-Datei den Ort und Namen des Log-Files ber den #'."\n";
   $OHfiles .= '#   Parameter LogFile ndern.                                                 #'."\n";
   $OHfiles .= '#   z.B. LogFile: /etc/DynAccessPoster.log                                    #'."\n";
   $OHfiles .= '#                                                                             #'."\n";
   $OHfiles .= '#                                                                             #'."\n";
   $OHfiles .= '#   Message-File: /var/log/DynAccessPoster.mess                               #'."\n";
   $OHfiles .= '#   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                               #'."\n";
   $OHfiles .= '#   Wichtige Informationen, die der DynAccessPoster liefert, knnen schon     #'."\n";
   $OHfiles .= '#   einmal unbeachtet bleiben, luft Ihr DynAccess-Account zu Ihrer vollsten  #'."\n";
   $OHfiles .= '#   Zufriedenheit.                                                            #'."\n";
   $OHfiles .= '#   Im normalen Log-File werden auch Informationen protokolliert, die der     #'."\n";
   $OHfiles .= '#   Client bei einer Account-Aktualisierung vom DynAccess-Server erhlt.      #'."\n";
   $OHfiles .= '#   Diese Informationen protokollieren wir zustzlich in einem weiteren       #'."\n";
   $OHfiles .= '#   Log-File, worauf Sie regelmig einen Blick haben sollten.                #'."\n";
   $OHfiles .= '#   Sie knnen ber die Config-Datei den Ort und Namen des Message-Log-Files  #'."\n";
   $OHfiles .= '#   ber den Parameter MessFile ndern.                                       #'."\n";
   $OHfiles .= '#   z.B. MessFile: /etc/DynAccessPoster.mess                                  #'."\n";
   $OHfiles .= '#                                                                             #'."\n";
   $OHfiles .= '###############################################################################'."\n";
} else {
   $OHfiles .= '###############################################################################'."\n";
   $OHfiles .= '#                               #                                             #'."\n";
   $OHfiles .= '#   further DynAccess files     #                                             #'."\n";
   $OHfiles .= '#                               #                                             #'."\n";
   $OHfiles .= '#################################                                             #'."\n";
   $OHfiles .= '#                                                                             #'."\n";
   $OHfiles .= '#   The script writes the following files:                                    #'."\n";
   $OHfiles .= '#                                                                             #'."\n";
   $OHfiles .= '#   Pid file: /var/run/DynAccessPoster.pid                                    #'."\n";
   $OHfiles .= '#   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                                    #'."\n";
   $OHfiles .= '#   The current process ID is written into this file.                         #'."\n";
   $OHfiles .= '#   This is important since you can start DynAccessPoster more than once.     #'."\n";
   $OHfiles .= '#   Each additional instance terminates automatically when it it notices that #'."\n";
   $OHfiles .= '#   DynAccessPoster is already running.                                       #'."\n";
   $OHfiles .= '#   Deleting this file causes the automatic termination of DynAccessPoster.   #'."\n";
   $OHfiles .= '#   You can change the location of the Pid file via the parameter PidFile.    #'."\n";
   $OHfiles .= '#   e.g. PidFile: /etc/DynAccess.pid                                          #'."\n";
   $OHfiles .= '#                                                                             #'."\n";
   $OHfiles .= '#                                                                             #'."\n";
   $OHfiles .= '#   Log file: /var/log/DynAccessPoster.log                                    #'."\n";
   $OHfiles .= '#   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                                    #'."\n";
   $OHfiles .= '#   The log is written into this file.  You should keep a watchfile eye on    #'."\n";
   $OHfiles .= '#   this when initially using DynAccessPoster.                                #'."\n";
   $OHfiles .= '#   If your internet connection is near its maximum load, then it is possible #'."\n";
   $OHfiles .= '#   that the log is filled with numerous error messages.  In the short term,  #'."\n";
   $OHfiles .= '#   this is not a problem.                                                    #'."\n";
   $OHfiles .= '#   In case of errors, the script tries, at short intervals, to carry out a   #'."\n";
   $OHfiles .= '#   successful update.  Compare this log with the log of your DynAccess       #'."\n";
   $OHfiles .= '#   account at http://myaccount.dynaccess.com                                 #'."\n";
   $OHfiles .= '#   In no case should repeated errors in the log file be a permanent          #'."\n";
   $OHfiles .= '#   situation.                                                                #'."\n";
   $OHfiles .= '#   If you use programs such as "eDonkey", please limit the up- and dowloads  #'."\n";
   $OHfiles .= '#   so that DynAccessPoster as well has enough bandwidth for problem-free     #'."\n";
   $OHfiles .= '#   account updates.  This is especially important when using the HeartBeat,  #'."\n";
   $OHfiles .= '#   which sends connectionless UDP packets.                                   #'."\n";
   $OHfiles .= '#   You can change the location and name of the log file via the parameter    #'."\n";
   $OHfiles .= '#   LogFile.                                                                  #'."\n";
   $OHfiles .= '#   e.g. LogFile: /etc/DynAccessPoster.log                                    #'."\n";
   $OHfiles .= '#                                                                             #'."\n";
   $OHfiles .= '#                                                                             #'."\n";
   $OHfiles .= '#   Message-File: /var/log/DynAccessPoster.mess                               #'."\n";
   $OHfiles .= '#   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                               #'."\n";
   $OHfiles .= '#   Important information which DynAccessPoster delivers can be overlooked    #'."\n";
   $OHfiles .= '#   if your DynAccess account is running completely satisfactorily.           #'."\n";
   $OHfiles .= '#   Information which the client receives from the DynAccess server during an #'."\n";
   $OHfiles .= '#   account update is also written to the normal log file.                    #'."\n";
   $OHfiles .= '#   This information is additionally written to a further log file, which you #'."\n";
   $OHfiles .= '#   should inspect regularly.                                                 #'."\n";
   $OHfiles .= '#   You can change the location and name of the message-log file via the      #'."\n";
   $OHfiles .= '#   parameter MessFile.                                                       #'."\n";
   $OHfiles .= '#   e.g. MessFile: /etc/DynAccessPoster.mess                                  #'."\n";
   $OHfiles .= '#                                                                             #'."\n";
   $OHfiles .= '###############################################################################'."\n";
}

my $OHadvanced = '';
if ($INI{'LANGUAGE'} =~ /d/) {
   $OHadvanced .= '###############################################################################'."\n";
   $OHadvanced .= '#                        #                                                    #'."\n";
   $OHadvanced .= '#   advanced Parameter   #                                                    #'."\n";
   $OHadvanced .= '#                        #                                                    #'."\n";
   $OHadvanced .= '##########################                                                    #'."\n";
   $OHadvanced .= '#                                                                             #'."\n";
   $OHadvanced .= '#     noTTY         Das Programm versucht wichtige Informationen auf          #'."\n";
   $OHadvanced .= '#                   smtliche Konsolen und SSH-Sessions zu schicken, in der   #'."\n";
   $OHadvanced .= '#                   Hoffnung, ein Server-Administrator nimmt die Information  #'."\n";
   $OHadvanced .= '#                   wahr.                                                     #'."\n";
   $OHadvanced .= '#                   Bei einem unbeaufsichtigten Linux-Server u.U. ein Problem.#'."\n";
   $OHadvanced .= '#                   Mit der Angabe von noTTY verhindern Sie dies.             #'."\n";
   $OHadvanced .= '#                                                                             #'."\n";
   $OHadvanced .= '#     noTTY2        Im Gegensatz zu noTTY wird hier lediglich die Ausgabe der #'."\n";
   $OHadvanced .= '#                   Message-Informationen auf den SSH-Konsolen verhindert.    #'."\n";
   $OHadvanced .= '#                   Auf der Hauptkonsole werden die Informationen nach wie    #'."\n";
   $OHadvanced .= '#                   vor ausgegeben, welches Sie mit noTTY unterbinden knnen. #'."\n";
   $OHadvanced .= '#                                                                             #'."\n";
   $OHadvanced .= '#     noBEEP        Hat der DynAccessPoster vom DynAccess-Server eine         #'."\n";
   $OHadvanced .= '#                   Nachricht erhalten, die auf der Konsole signalisiert      #'."\n";
   $OHadvanced .= '#                   wird, wird dies am Server im 60-Sekunden-Takt mit einem   #'."\n";
   $OHadvanced .= '#                   "Beep" signalisiert.                                      #'."\n";
   $OHadvanced .= '#                   Mit dem Aufrufparameter noBEEP deaktivieren Sie diese     #'."\n";
   $OHadvanced .= '#                   Funktion, sofern nicht bereits noTTY gesetzt wurde,       #'."\n";
   $OHadvanced .= '#                   welches die akustische Signalisierung ebenfalls           #'."\n";
   $OHadvanced .= '#                   deaktiviert.                                              #'."\n";
   $OHadvanced .= '#                                                                             #'."\n";
   $OHadvanced .= '#     noLOGfile     Hiermit knnen Sie das Logging deaktivieren.              #'."\n";
   $OHadvanced .= '#                                                                             #'."\n";
   $OHadvanced .= '#     noMESSfile    Hiermit deaktivieren Sie das zustzliche Message-Log.     #'."\n";
   $OHadvanced .= '#                                                                             #'."\n";
   $OHadvanced .= '#     noCONFfile    Hierber deaktivieren Sie das notwendige Vorhandensein    #'."\n";
   $OHadvanced .= '#                   einer Konfigurationsdatei.                                #'."\n";
   $OHadvanced .= '#                                                                             #'."\n";
   $OHadvanced .= '###############################################################################'."\n";
} else {
   $OHadvanced .= '###############################################################################'."\n";
   $OHadvanced .= '#                        #                                                    #'."\n";
   $OHadvanced .= '#   advanced parameters  #                                                    #'."\n";
   $OHadvanced .= '#                        #                                                    #'."\n";
   $OHadvanced .= '##########################                                                    #'."\n";
   $OHadvanced .= '#                                                                             #'."\n";
   $OHadvanced .= '#     noTTY         The program tries to send important information to all    #'."\n";
   $OHadvanced .= '#                   consoles and SSH sessions in the hope that a server       #'."\n";
   $OHadvanced .= '#                   administrator will notice the information.                #'."\n";
   $OHadvanced .= '#                   This could perhaps be a problem for an unmanaged Linux    #'."\n";
   $OHadvanced .= '#                   server.                                                   #'."\n";
   $OHadvanced .= '#                   Specifying the parameter noTTY prevents this.             #'."\n";
   $OHadvanced .= '#                                                                             #'."\n";
   $OHadvanced .= '#     noTTY2        In contrast to noTTY, in this case only the printing of   #'."\n";
   $OHadvanced .= '#                   the message information to the SSH consoles is prevented. #'."\n";
   $OHadvanced .= '#                   At the main console, the information is still provided,   #'."\n";
   $OHadvanced .= '#                   which can be suppressed with noTTY.                       #'."\n";
   $OHadvanced .= '#                                                                             #'."\n";
   $OHadvanced .= '#     noBEEP        If DynAccessPoster has received a message which is to be  #'."\n";
   $OHadvanced .= '#                   indicated at the console, this is signalled by a "beep"   #'."\n";
   $OHadvanced .= '#                   at 60-second intervals.                                   #'."\n";
   $OHadvanced .= '#                   Specifying the calling parameter noBEEP deactivates this  #'."\n";
   $OHadvanced .= '#                   function, as long as noTTY hasn\'t already been specified, #'."\n";
   $OHadvanced .= '#                   which also deactivates the acoustic signalling.           #'."\n";
   $OHadvanced .= '#                                                                             #'."\n";
   $OHadvanced .= '#     noLOGfile     Here you can deactivate logging.                          #'."\n";
   $OHadvanced .= '#                                                                             #'."\n";
   $OHadvanced .= '#     noMESSfile    Here you can deactivate the supplementary message log.    #'."\n";
   $OHadvanced .= '#                                                                             #'."\n";
   $OHadvanced .= '#     noCONFfile    Here you can deactivate the necessary presence of a       #'."\n";
   $OHadvanced .= '#                   configuration file.                                       #'."\n";
   $OHadvanced .= '#                                                                             #'."\n";
   $OHadvanced .= '###############################################################################'."\n";
}

my $OHmd5 = '';
if ($INI{'LANGUAGE'} =~ /d/) {
   $OHmd5 .= '###############################################################################'."\n";
   $OHmd5 .= '#                    #                                                        #'."\n";
   $OHmd5 .= '#   optionales MD5   #                                                        #'."\n";
   $OHmd5 .= '#                    #                                                        #'."\n";
   $OHmd5 .= '######################                                                        #'."\n";
   $OHmd5 .= '#                                                                             #'."\n";
   $OHmd5 .= '# Um die Passwortbergabe nicht im Klartext erfolgen zu lassen, ist es        #'."\n";
   $OHmd5 .= '# mglich, ein MD5-verschlsseltes Passwort zu bergeben.                     #'."\n";
   $OHmd5 .= '# Sie knnen Ihr bereits MD5-verschlsseltes Passwort in der Konfiguration    #'."\n";
   $OHmd5 .= '# eintragen. Dieses erhalten Sie via http://myaccount.dynaccess.de.           #'."\n";
   $OHmd5 .= '#                                                                             #'."\n";
   $OHmd5 .= '# Zur Steigerung der Sicherheit untersttzt der DynAccessPoster alle Anstze  #'."\n";
   $OHmd5 .= '# zur Verschlsselung, die wir auf http://www.dynaccess.de beschrieben haben. #'."\n";
   $OHmd5 .= '# So knnen Sie Ihr Passwort bei der Account-Aktualisierung nochmals gegen    #'."\n";
   $OHmd5 .= '# einen vom DynAccess-Server definierten String MD5 verschlsseln lassen.     #'."\n";
   $OHmd5 .= '# Dies setzt jedoch voraus, dass Sie bei Einsatz des Perl-Scriptes das Perl-  #'."\n";
   $OHmd5 .= '# Modul "Digest::MD5" installiert haben.                                      #'."\n";
   $OHmd5 .= '# Beim Programmstart prft der DynAccessPoster dies und aktiviert die         #'."\n";
   $OHmd5 .= '# zustzliche MD5-Verschlsselung.                                            #'."\n";
   $OHmd5 .= '# Da die Verschlsselung gegen einen vom DynAccess-Server angeforderten       #'."\n";
   $OHmd5 .= '# Zusatzstring erfolgt, verlngert es die Kommunikation zum DynAccess-Server. #'."\n";
   $OHmd5 .= '# Ist Ihre InterNet-Anbindung oder aber auch Ihr Rechner berlastet, kann es  #'."\n";
   $OHmd5 .= '# vorkommen, dass die Account-Aktualisierung nicht binnen 5 Sekunden          #'."\n";
   $OHmd5 .= '# abgeschlossen ist und serverseitig abgebrochen wird.                        #'."\n";
   $OHmd5 .= '#                                                                             #'."\n";
   $OHmd5 .= '# Die zustzliche MD5-Verschlsselung knnen Sie deaktivieren, rufen Sie das  #'."\n";
   $OHmd5 .= '# DynAccess-Script mit dem Parameter "noMD5" (ohne Anfhrungszeichen) auf.    #'."\n";
   $OHmd5 .= '#                                                                             #'."\n";
   $OHmd5 .= '###############################################################################'."\n";
} else {
   $OHmd5 .= '###############################################################################'."\n";
   $OHmd5 .= '#                    #                                                        #'."\n";
   $OHmd5 .= '#   optional   MD5   #                                                        #'."\n";
   $OHmd5 .= '#                    #                                                        #'."\n";
   $OHmd5 .= '######################                                                        #'."\n";
   $OHmd5 .= '#                                                                             #'."\n";
   $OHmd5 .= '# In order to prevent the password from being transmitted in plain text,      #'."\n";
   $OHmd5 .= '# it is possible to pass an MD5-encoded password.                             #'."\n";
   $OHmd5 .= '# You can enter your already MD5-encoded password in the configuration.  This #'."\n";
   $OHmd5 .= '# can be obtained via http://myaccount.dynaccess.com.                         #'."\n";
   $OHmd5 .= '#                                                                             #'."\n";
   $OHmd5 .= '# In order to increase security, DynAccessPoster supports all types of        #'."\n";
   $OHmd5 .= '# encoding which we have described at http://www.dynaccess.com.               #'."\n";
   $OHmd5 .= '# You can thus encode your password a second time against an MD5 string       #'."\n";
   $OHmd5 .= '# defined by a DynAccess server during an account update.                     #'."\n";
   $OHmd5 .= '# However, this assumes that when using the Perl script you have installed    #'."\n";
   $OHmd5 .= '# the Perl module "Digest::MD5.                                               #'."\n";
   $OHmd5 .= '# At program start, DynAccessPoster checks this and activates the additional  #'."\n";
   $OHmd5 .= '# MD5 encoding.                                                               #'."\n";
   $OHmd5 .= '# Since the encoding uses an additional string requested from the DynAccess   #'."\n";
   $OHmd5 .= '# server, this lengthens the communication to the DynAccess server.           #'."\n";
   $OHmd5 .= '# If your internet connection or your computers are overloaded, then it can   #'."\n";
   $OHmd5 .= '# happen that your account update isn\'t completed within 5 seconds and is     #'."\n";
   $OHmd5 .= '# thus terminated by the server.                                              #'."\n";
   $OHmd5 .= '#                                                                             #'."\n";
   $OHmd5 .= '# You can deactivate the additional MD5 encoding by calling the DynAccess     #'."\n";
   $OHmd5 .= '# script with the parameter "noMD5" (without quotes).                         #'."\n";
   $OHmd5 .= '#                                                                             #'."\n";
   $OHmd5 .= '###############################################################################'."\n";
}

my $OHerror = '';
if ($INI{'LANGUAGE'} =~ /d/) {
   $OHerror .= '###############################################################################'."\n";
   $OHerror .= '#                         #                                                   #'."\n";
   $OHerror .= '#   Fehlermeldungen       #                                                   #'."\n";
   $OHerror .= '#   und deren Bedeutung   #                                                   #'."\n";
   $OHerror .= '#                         #                                                   #'."\n";
   $OHerror .= '###########################                                                   #'."\n";
   $OHerror .= '#                                                                             #'."\n";
   $OHerror .= '# Das Script informiert Sie ber das LogFile mit aussagekrftigen             #'."\n";
   $OHerror .= '# Informationen. Das zustzliche Message-File sollten Sie immer im Auge       #'."\n";
   $OHerror .= '# haben, auch wenn Ihr Account bestens funktioniert.                          #'."\n";
   $OHerror .= '#                                                                             #'."\n";
   $OHerror .= '# Folgende Logfileeintrge mchten wir jedoch erlutern:                      #'."\n";
   $OHerror .= '#                                                                             #'."\n";
   $OHerror .= '# a) There is a problem to do a myIP                                          #'."\n";
   $OHerror .= '#    Konnte eigene IP nicht ermitteln                                         #'."\n";
   $OHerror .= '#                                                                             #'."\n";
   $OHerror .= '#    Der DynAccessPoster bezieht ber einen DynAccess-Server im festen        #'."\n";
   $OHerror .= '#    (kurzen) Intervall Ihre derzeitige IP.                                   #'."\n";
   $OHerror .= '#    Stellt der DynAccessPoster einen IP-Wechsel fest, wird ein setIP, sprich #'."\n";
   $OHerror .= '#    eine Account-Aktualisierung, durchgefhrt.                               #'."\n";
   $OHerror .= '#    Erhalten Sie die Fehlermeldung, dass kein myIP durchgefhrt werden       #'."\n";
   $OHerror .= '#    konnte, ist davon auszugehen, dass Ihre InterNet-Verbindung derzeit bei  #'."\n";
   $OHerror .= '#    hoher Last luft oder nicht besteht.                                     #'."\n";
   $OHerror .= '#    Das Script konnte innerhalb einer fest vorgegebenen Zeitspanne keine     #'."\n";
   $OHerror .= '#    Verbindung zum DynAccess-Server aufnehmen. Der Versuch wurde abgebrochen #'."\n";
   $OHerror .= '#    und wird kurze Zeit spter erneut ausgefhrt.                            #'."\n";
   $OHerror .= '#    Liegt das Problem an einem nicht erreichbaren DynAccess-Server, greift   #'."\n";
   $OHerror .= '#    der DynAccessPoster automatisch auf einen anderen Server zu.             #'."\n";
   $OHerror .= '#    Ein derartiger Eintrag ab und an einmal ist nicht ungewhnlich.          #'."\n";
   $OHerror .= '#    Bei einer hohen Zahl von derartigen Fehlermeldungen sollten Sie          #'."\n";
   $OHerror .= '#    Gegenmassnahmen ergreifen, um dem DynAccessPoster einen problemlosen     #'."\n";
   $OHerror .= '#    Lauf zu ermglichen, wobei Sie auch die Ressourcen unserer DynAccess-    #'."\n";
   $OHerror .= '#    Server schonen.                                                          #'."\n";
   $OHerror .= '#    I.d.R. wird eine Verbindung aufgebaut, die bei Erreichen des Timeouts    #'."\n";
   $OHerror .= '#    abgebrochen wird, weil die Operation nicht schnell genug durchgefhrt    #'."\n";
   $OHerror .= '#    werden konnte.                                                           #'."\n";
   $OHerror .= '#                                                                             #'."\n";
   $OHerror .= '#                                                                             #'."\n";
   $OHerror .= '# b) There is a problem to do a setIP                                         #'."\n";
   $OHerror .= '#    Kann Account-Aktualisierung nicht durchfhren                            #'."\n";
   $OHerror .= '#                                                                             #'."\n";
   $OHerror .= '#    Der DynAccessPoster konnte keine Account-Aktualisierung durchfhren.     #'."\n";
   $OHerror .= '#    Hier sind die gleichen Ursachen zu suchen, wie unter a) erlutert.       #'."\n";
   $OHerror .= '#    Bei regelmigen Problemen oder gar bei gelegentlichen Neutralisierungen #'."\n";
   $OHerror .= '#    Ihres DynAccess-Accounts, sollten Sie aktiv werden, um das Problem zu    #'."\n";
   $OHerror .= '#    lsen.                                                                   #'."\n";
   $OHerror .= '#                                                                             #'."\n";
   $OHerror .= '###############################################################################'."\n";
} else {
   $OHerror .= '###############################################################################'."\n";
   $OHerror .= '#                         #                                                   #'."\n";
   $OHerror .= '#   error messages        #                                                   #'."\n";
   $OHerror .= '#   and their meaning     #                                                   #'."\n";
   $OHerror .= '#                         #                                                   #'."\n";
   $OHerror .= '###########################                                                   #'."\n";
   $OHerror .= '#                                                                             #'."\n";
   $OHerror .= '# The script informs you via the log file with detailed information.  You     #'."\n";
   $OHerror .= '# should always keep an eye on the additional message file, even if your      #'."\n";
   $OHerror .= '# account is functioning well.                                                #'."\n";
   $OHerror .= '#                                                                             #'."\n";
   $OHerror .= '# However, we would like to explain the following log-file entries:           #'."\n";
   $OHerror .= '#                                                                             #'."\n";
   $OHerror .= '# a) There is a problem to do a myIP                                          #'."\n";
   $OHerror .= '#                                                                             #'."\n";
   $OHerror .= '#    DynAccessPoster obtains your current IP at fixed (short) intervals from  #'."\n";
   $OHerror .= '#    a DynAccess server.                                                      #'."\n";
   $OHerror .= '#    If DynAccessPoster detects an IP change, a setIP, i.e. an account        #'."\n";
   $OHerror .= '#    update, is performed.                                                    #'."\n";
   $OHerror .= '#    If you receive the error message that no myIP could be carried out, then #'."\n";
   $OHerror .= '#    you can assume that the internet connection is overloaded or             #'."\n";
   $OHerror .= '#    non-existent.                                                            #'."\n";
   $OHerror .= '#    The script could not establish a connection to a DynAccess server within #'."\n";
   $OHerror .= '#    a fixed given time span.  The attempt was terminated and will be carried #'."\n";
   $OHerror .= '#    out again after a short time.                                            #'."\n";
   $OHerror .= '#    If the problem is due to an unreachable DynAccess server,                #'."\n";
   $OHerror .= '#    DynAccessPoster automatically accesses another server.                   #'."\n";
   $OHerror .= '#    The occasional occurrence of such an entry is not unusual.               #'."\n";
   $OHerror .= '#    In case of a large number of such error messages, you should take        #'."\n";
   $OHerror .= '#    appropriate action in order to allow DynAccessPoster to operate properly #'."\n";
   $OHerror .= '#    and conserve the resources of our DynAccess servers.                     #'."\n";
   $OHerror .= '#    Usually a connection is established which is terminated when a timeout   #'."\n";
   $OHerror .= '#    is reached since the operation could not be carried out quickly enough.  #'."\n";
   $OHerror .= '#                                                                             #'."\n";
   $OHerror .= '#                                                                             #'."\n";
   $OHerror .= '# b) There is a problem to do a setIP                                         #'."\n";
   $OHerror .= '#                                                                             #'."\n";
   $OHerror .= '#    DynAccessPoster could not carry out an account update.                   #'."\n";
   $OHerror .= '#    The same causes are to be investigated as described under a).            #'."\n";
   $OHerror .= '#    In the case of regular problems or even occasional neutralisation of     #'."\n";
   $OHerror .= '#    your DynAccess account, you should take action to solve the problem.     #'."\n";
   $OHerror .= '#                                                                             #'."\n";
   $OHerror .= '###############################################################################'."\n";
}

my $OHcron = '';
if ($INI{'LANGUAGE'} =~ /d/) {
   $OHcron .= '###############################################################################'."\n";
   $OHcron .= '#                   #                                                         #'."\n";
   $OHcron .= '#   CRON-Beispiel   #                                                         #'."\n";
   $OHcron .= '#                   #                                                         #'."\n";
   $OHcron .= '#####################                                                         #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '# Mittels CRON knnen Sie unter Linux zeitgesteuert Programme und Scripte     #'."\n";
   $OHcron .= '# ausfhren.                                                                  #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '# Mchten Sie mit DynAccess keine Quasi-Standleitung realisieren, sondern     #'."\n";
   $OHcron .= '# Ihre Ressourcen nur zu bestimmten Zeiten zur Verfgung stellen, so knnen   #'."\n";
   $OHcron .= '# Sie dies sehr einfach realisieren.                                          #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '# Starten Sie mittels CRON das Script ber den Aufruf                         #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '#    bash:~ # perl DynAccessPoster.pl                                         #'."\n";
   $OHcron .= '# bzw.                                                                        #'."\n";
   $OHcron .= '#    bash:~ # ./DynAccessPoster                                               #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '# um Ihren Account zu einer bestimmten Uhrzeit zu aktivieren.                 #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '# Mittels                                                                     #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '#    bash:~ # perl DynAccessPoster.pl offline                                 #'."\n";
   $OHcron .= '# bzw.                                                                        #'."\n";
   $OHcron .= '#    bash:~ # ./DynAccessPoster offline                                       #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '# wird Ihr Account neutralisiert. Ferner werden alle Instanzen des            #'."\n";
   $OHcron .= '# DynAccessPosters automatisch beendet.                                       #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '###############################################################################'."\n";
} else {
   $OHcron .= '###############################################################################'."\n";
   $OHcron .= '#                   #                                                         #'."\n";
   $OHcron .= '#   CRON example    #                                                         #'."\n";
   $OHcron .= '#                   #                                                         #'."\n";
   $OHcron .= '#####################                                                         #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '# Via CRON, you can execute timed scripts and programs under Linux.           #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '# If you would not like to set up a quasi-permanent connection with DynAccess #'."\n";
   $OHcron .= '# but rather would like to make your resources available only at certain      #'."\n";
   $OHcron .= '# times, then you can achieve this very simply.                               #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '# Start the script via CRON with the command                                  #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '#    bash:~ # perl DynAccessPoster.pl                                         #'."\n";
   $OHcron .= '# or                                                                          #'."\n";
   $OHcron .= '#    bash:~ # ./DynAccessPoster                                               #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '# in order to activate your account at a certain time.                        #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '# Via                                                                         #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '#    bash:~ # perl DynAccessPoster.pl offline                                 #'."\n";
   $OHcron .= '# or                                                                          #'."\n";
   $OHcron .= '#    bash:~ # ./DynAccessPoster offline                                       #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '# your accont is neutralised.  In addition, all instances of DynAccessPoster  #'."\n";
   $OHcron .= '# are automatically terminated.                                               #'."\n";
   $OHcron .= '#                                                                             #'."\n";
   $OHcron .= '###############################################################################'."\n";
}

my $OHcopyright = '';
if ($INI{'LANGUAGE'} =~ /d/) {
   $OHcopyright .= '###############################################################################'."\n";
   $OHcopyright .= '#                                                                             #'."\n";
   $OHcopyright .= '#                            C O P Y R I G H T                                #'."\n";
   $OHcopyright .= '#                by Ambos InterNet-Solutions in 2001..$year                    #'."\n";
   $OHcopyright .= '#                          http://www.ambos-is.net                            #'."\n";
   $OHcopyright .= '#                                                                             #'."\n";
   $OHcopyright .= '#             DynAccess ist ein professioneller DynDNS-Dienst                 #'."\n";
   $OHcopyright .= '#                          http://www.dynaccess.de                            #'."\n";
   $OHcopyright .= '#                                                                             #'."\n";
   $OHcopyright .= '###############################################################################'."\n";
   $OHcopyright .= '#                                                                             #'."\n";
   $OHcopyright .= '#                          Version  vom $BuildDate                            #'."\n";
   $OHcopyright .= '#                                                                             #'."\n";
   $OHcopyright .= '###############################################################################'."\n";
} else {
   $OHcopyright .= '###############################################################################'."\n";
   $OHcopyright .= '#                                                                             #'."\n";
   $OHcopyright .= '#                            C O P Y R I G H T                                #'."\n";
   $OHcopyright .= '#                by Ambos InterNet-Solutions in 2001..$year                    #'."\n";
   $OHcopyright .= '#                         http://www.ambos-is.net                             #'."\n";
   $OHcopyright .= '#                                                                             #'."\n";
   $OHcopyright .= '#               DynAccess is a professional DynDNS service                    #'."\n";
   $OHcopyright .= '#                        http://www.dynaccess.com                             #'."\n";
   $OHcopyright .= '#                                                                             #'."\n";
   $OHcopyright .= '###############################################################################'."\n";
   $OHcopyright .= '#                                                                             #'."\n";
   $OHcopyright .= '#                          Version from $BuildDate                            #'."\n";
   $OHcopyright .= '#                                                                             #'."\n";
   $OHcopyright .= '###############################################################################'."\n";
}

$OHcopyright =~ s/\$year/$year/g;
$OHcopyright =~ s/\$BuildDate/$BuildDate/g;

$output .= $OHcopyright     if $topic !~ /^version$/;
$output .= $OHintro         if $topic =~ /^(\-h\-all|\-h\-intro)$/;
$output .= $OHhelp          if $topic =~ /^(\-h\-all|\-h)$/;
$output .= $OHstart         if $topic =~ /^(\-h\-all|\-h\-start)$/;
$output .= $OHconfigfile    if $topic =~ /^(\-h\-all|\-h\-configfile)$/;
$output .= $OHconfigdirect  if $topic =~ /^(\-h\-all|\-h\-configdirect)$/;
$output .= $OHfiles         if $topic =~ /^(\-h\-all|\-h\-files)$/;
$output .= $OHadvanced      if $topic =~ /^(\-h\-all|\-h\-advanced)$/;
$output .= $OHmd5           if $topic =~ /^(\-h\-all|\-h\-md5)$/;
$output .= $OHerror         if $topic =~ /^(\-h\-all|\-h\-error)$/;
$output .= $OHcron          if $topic =~ /^(\-h\-all|\-h\-cron)$/;

$output .= "$INI{'AUTHCODE'} build: $Build ($BuildDate)\n" if $topic =~ /^version$/;

print $output;
exit;


}

